/***************************************************************************
                          author.cpp  -  description
                             -------------------
    begin                : Tue Sep 7 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "author.h"
#include "kaspawidget.h"
#include "resource.h"
#include <kapp.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <kiconloader.h>
#include <klocale.h>
#include "notetreedlg.h"
#include "selectiondlg.h"

#define Inherited AuthorData


CommandSetup authorcs[] = {	{ID_AUTHOR_DELREC,  RW},
														{ID_AUTHOR_NEWLINK, RW+RO},
														{ID_AUTHOR_INSLINK, RW+RO},
														{ID_AUTHOR_REMLINK, RW+RO},
														{ID_AUTHOR_NEWPUBL, RW+RO},
														{ID_AUTHOR_INSPUBL, RW+RO},
														{ID_AUTHOR_REMPUBL, RW+RO},
														{ID_AUTHOR_FLUSH, 	RW},
														{ID_AUTHOR_INSPART, RW+RO},
														{ID_AUTHOR_REMPART, RW+RO},
														{ID_AUTHOR_RESET,		RW+RO+INV} };



// AuthorBase-Constructor reads row matching WHERE-Clause.
Author::Author(KaspaURL url, Sql *conn, QWidget* parent,	const char* name=0L):
  Inherited( parent, name) {
    setTabOrder(firstname, lastname);
		setTabOrder(lastname, pseudonym);
		setTabOrder(pseudonym, born);
		setTabOrder(born, died);
		setTabOrder(died, country);
		setTabOrder(country, memo);

	if(url.command()=="new")
	  author = new AuthorBase(conn);
	else
 		author = new AuthorBase(url.where(), conn);

  ASSERT(author);
	author->setCallBack(&idle);
	QString s("kaspa://author#where oid="); s+=QString().setNum(author->id());
	_url=s;

  connect(notelist, SIGNAL(open(Oid, bool)), this, SLOT(requestNote(Oid, bool)));
  connect(publlist, SIGNAL(open(Oid, bool)), this, SLOT(requestPublication(Oid, bool)));
  connect(partlist, SIGNAL(open(Oid, bool)), this, SLOT(requestPart(Oid, bool)));
	notelist->setTitle(i18n("Links"));
	publlist->setTitle(i18n("Publications"));
	partlist->setTitle(i18n("Chapters"));
}

Author::~Author() {
  debug("Author::~Author");
  delete author;
}

bool Author::isValid() {
	try {
	  return author->isValid();
	} catch(KaspaErr &err) {
		handleWarning(err);
		return false;
	}
}

void Author::reread() {
  debug("Author::reread()");
  setWorkingGUI();
	try {
	  author->reset();
	} catch(KaspaErr &err) {
		handleWarning(err);
	}
  setFields();
}

void Author::setFields() {
  if(isValid()) {
		try {
			setWorkingGUI();
  		firstname->setText(author->getFirstName());
	  	lastname->setText(author->getLastName());
	  	born->setText(author->getBirthday());
		  died->setText(author->getDay_of_Death());
  		pseudonym->setText(author->getPseudonym());
		  country->setText(author->getCountry());
  		memo->setText(author->getMemo());
			created->setText(QString("created: ")+author->getCreated());
			modified->setText(QString("modified: ")+author->getModified());

		  notelist->set(author->getLinks());
		  publlist->set(author->getPubl());
		  partlist->set(author->getParts());
		} catch(KaspaErr &err) {
			handleWarning(err);
		}
	}
  setupGUI();
}

void Author:: flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void Author::save(bool block) {
  debug("Author::save()");
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
	    if(strcmp(firstname->text(), author->getFirstName()))
	      author->setFirstName(firstname->text());
	    if(strcmp(lastname->text(), author->getLastName()))
	      author->setLastName(lastname->text());
	    if(strcmp(born->text(), author->getBirthday()))
	      author->setBirthday(born->text());
	    if(strcmp(died->text(), author->getDay_of_Death()))
	      author->setDay_of_Death(died->text());
	    if(strcmp(pseudonym->text(), author->getPseudonym()))
	      author->setPseudonym(pseudonym->text());
	    if(strcmp(country->text(), author->getCountry()))
	      author->setCountry(country->text());
	    if(strcmp(memo->text(), author->getMemo()))
	      author->setMemo(memo->text());
		    author->flush(block);
		}
	} catch(KaspaErr &err) {
		handleWarning(err);
	}
}

void Author::setInvalidGUI() {
  debug("Author::setInvalidGUI()");
  Inherited::setInvalidGUI();
  lockGUI();
	for(unsigned int i=0; i<sizeof(authorcs)/sizeof(CommandSetup); i++)
		emit enableCommand(authorcs[i].command, ((authorcs[i].setup&INV)==INV));
}	

void Author::setReadWriteGUI() {
  debug("Author::setReadWriteGUI()");
  Inherited::setReadWriteGUI();
  unlockGUI();
	for(unsigned int i=0; i<sizeof(authorcs)/sizeof(CommandSetup); i++)
		emit enableCommand(authorcs[i].command, ((authorcs[i].setup&RW)==RW));
}

void Author::setReadOnlyGUI() {
  debug("Author::setReadOnlyGUI()");	
  Inherited::setReadOnlyGUI();
  lockGUI();
  notelist->setEnabled(TRUE);
  publlist->setEnabled(TRUE);
	partlist->setEnabled(TRUE);
	for(unsigned int i=0; i<sizeof(authorcs)/sizeof(CommandSetup); i++)
		emit enableCommand(authorcs[i].command, ((authorcs[i].setup&RO)==RO));
}

void Author::setWorkingGUI() {
  debug("Author::setWorkingGUI()");
	if(isReadOnly() || !isValid())
		lockGUI();
	else
		unlockGUI();
  Inherited::setWorkingGUI();
  notelist->setEnabled(FALSE);
  publlist->setEnabled(FALSE);
	partlist->setEnabled(FALSE);
	for(unsigned int i=0; i<sizeof(authorcs)/sizeof(CommandSetup); i++)
		emit enableCommand(authorcs[i].command, ((authorcs[i].setup&WORK)==WORK));
}


void Author::del() {
	try  {
	  if(isValid() && !isReadOnly() && !isWorking() && deleteDlg()) {
	    setWorkingGUI();
	    author->deleteRec();
	    setInvalidGUI();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

bool Author::closeRequest() {
  save(true);
	setupGUI();
  return true;
}


void Author::newLink() {
	try {
		Oid o=author->createNote();
		requestNote(o);
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void Author::insLink() {
	try {
		NoteTitle *notes=author->getNotes();
		PublTitle *publs=author->getPubls();
		NoteTreeDlg dlg(notes, publs);
		if(dlg.exec()) {
			if(dlg.getOid()==InvalidOid) return;
			setWorkingGUI();
			author->insertLink(dlg.getOid());
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

/*
	try {
		SelectionDlg dlg(author->getNotes(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			author->insertLink(o);
			save();
			setFields();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
*/

void Author::remLink() {
	try {
		Oid o=notelist->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		author->removeLink(o);
		save();
		setFields();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
		
void Author::newPubl() {
	try {
		Oid o=author->createPubl();
		requestPublication(o);
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}
	
void Author::insPubl() {
	try {
		SelectionDlg dlg(author->getPubls(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			author->insertPubl(o);
			save();
			setFields();			
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	
void Author::remPubl() {
	try {
		Oid o=publlist->getCurrentOid();
		if(o==InvalidOid) return;
		setWorkingGUI();
		author->removePubl(o);
		save();
		setFields();	
		} catch(KaspaErr& err) {
			handleWarning(err);
		}
}
		
void Author::insPart() {
	try {
		SelectionDlg dlg(author->getParts(), this);
		if(dlg.exec()) {
			Oid o=dlg.getOid();
			if(o==InvalidOid) return;
			setWorkingGUI();
			author->insertPart(o);
			save();
			setFields();	
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}		
	
void Author::remPart() {
	try {
	Oid o=partlist->getCurrentOid();
	if(o==InvalidOid) return;
		setWorkingGUI();
		author->removePart(o);
		save();
		setFields();	
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

KToolBar *Author::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
  toolbar->insertButton(BarIcon("newnote.xpm"), ID_AUTHOR_NEWLINK, SIGNAL(clicked()),
				this, SLOT(newLink()), true, i18n("New Note") );
  toolbar->insertButton(BarIcon("insnote.xpm"), ID_AUTHOR_INSLINK, SIGNAL(clicked()),
				this, SLOT(insLink()), true, i18n("Insert Note") );
  toolbar->insertButton(BarIcon("delnote.xpm"), ID_AUTHOR_REMLINK, SIGNAL(clicked()),
				this, SLOT(remLink()), true, i18n("Delete Note") );
	toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("newpubl.xpm"), ID_AUTHOR_NEWPUBL, SIGNAL(clicked()),
				this, SLOT(newPubl()), true, i18n("New Publication") );
  toolbar->insertButton(BarIcon("inspubl.xpm"), ID_AUTHOR_INSPUBL, SIGNAL(clicked()),
				this, SLOT(insPubl()), true, i18n("Insert Publication") );
  toolbar->insertButton(BarIcon("delpubl.xpm"), ID_AUTHOR_REMPUBL, SIGNAL(clicked()),
				this, SLOT(remPubl()), true, i18n("Remove Publication") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("inspart.xpm"), ID_AUTHOR_INSPART, SIGNAL(clicked()),
				this, SLOT(insPart()), true, i18n("Insert Part") );
  toolbar->insertButton(BarIcon("delpart.xpm"), ID_AUTHOR_REMPART, SIGNAL(clicked()),
				this, SLOT(remPart()), true, i18n("Remove Part") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filedel.xpm"), ID_AUTHOR_DELREC, SIGNAL(clicked()),
				this, SLOT(del()), true, i18n("Delete Record") );
  toolbar->insertLineSeparator();
  toolbar->insertButton(BarIcon("filefloppy.xpm"), ID_AUTHOR_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
  toolbar->insertButton(BarIcon("reload.xpm"), ID_AUTHOR_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );
	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
  return toolbar;
}
