CREATE TABLE author (
	lastname	text,
	firstname	text,
	pseudonym	text,
	born		text,
	died	        text,
	country		text,
	memo		oid,
	picture		oid,
	created		timestamp,
	modified	timestamp
);
CREATE INDEX author_oid_index ON author (oid);

CREATE TABLE part (
	publicationno	oid,
	partno    	int2,
	title     	text,
	pages     	text,
	memo   		oid,
	key       	text,
	language	text,
	bibtex	  	text,
	intro     	oid,
	createbibtex	bool,
	created		timestamp,
	modified	timestamp
);
CREATE INDEX part_publicationno_index ON part (publicationno);
CREATE INDEX part_oid_index ON part (oid);


CREATE TABLE partdata (
	partno	  oid,
	file		oid,
	filename	text,
	type      	text,
	created		timestamp,
	modified	timestamp
);
CREATE INDEX partdata_oid_index ON partdata (oid);
CREATE INDEX partdata_partno_index ON partdata (partno);

CREATE TABLE publisher (
        name		text,
        city		text,
	serie	        text,
	created		timestamp,
	modified	timestamp
);

CREATE TABLE publication (
	title			 text,
	subtitle		 text,
	edition			 int2,
	editor       		 text,
	howpublished 		 text,
	organization 		 text,
	publisher		 oid,
	year      		 text,
	pages  			 text,
	translator		 text,
	volume			 text,
	number  		 text,
	month   		 text,
	series  		 text,
	type    		 text,
	key     		 text,
	orgtitle		 text,
	orgpublisher 		 oid,
	orgyear	    		 text,
	isbn_issn		 text,
	hidingplace  		 text,
	bibtex			 text,
	entrytype		 int2,
	memo   			 oid,
	createbibtex 		 bool,
	created		 	 timestamp,
	modified		 timestamp
);
CREATE INDEX publication_oid_index ON publication (oid);

CREATE TABLE publication_author (
	publicationno	 oid,
	authorno	 oid,
	created		 timestamp,
	modified	 timestamp
);
CREATE INDEX publication_author_authorno_index ON publication_author (authorno);
CREATE INDEX publication_author_bookno_index ON publication_author (publicationno);

CREATE TABLE part_author (
	partno		oid,
	authorno	oid,
	created		timestamp,
	modified	timestamp
);
CREATE INDEX part_author_authorno_index ON part_author (authorno);
CREATE INDEX part_author_partno_index ON part_author (partno);


CREATE TABLE note (
	title		text,
	memo		oid,
	type		int2,
	publicationno	oid,
	created		timestamp,
	modified	timestamp
);
CREATE INDEX note_oid_index ON note (oid);
CREATE INDEX note_publicationno_index ON note (publicationno);

CREATE TABLE dictionary (
	word		text
);
CREATE INDEX dictionary_word_index ON dictionary (word);

CREATE TABLE word (
	dictionaryno	oid,
	obj		oid,
	pos     	int4,
	tab		oid,
	type		int2
);
CREATE INDEX word_dictionaryno_index ON word (dictionaryno);
CREATE INDEX word_obj_index ON word (obj);

CREATE TABLE analyzed (
	obj			oid
);
CREATE INDEX analyzed_obj_index ON analyzed (obj);


CREATE TABLE link (
	obj1		oid,
	obj2		oid,
	tbl		text,
	created		timestamp,
	modified	timestamp
);
