/***************************************************************************
                          authorbase.h  -  description
                             -------------------
    begin                : Tue Sep 7 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AUTHORBASE_H
#define AUTHORBASE_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "table.h"

struct Oid_Str_Rec {
  Str publ;
  Oid o;
};


/**
  * @author Jan Mller
  * @version 0.2
  * This class bundles all methods to access a tuple from table author and
	* implements the methods which connect this tuple with other tuples.
  * It inherits the delete/reread/save/lock/unlock handling from @ref Table
  * (it has to reimplement @ref del, @ref read, @ref write) and the general
  * access methods from @ref KaspaBase. Mmhh, maybe more complicated as it
  * should be.
  * Execptions: All execeptions are derived from @ref SqlErr. They contain
  * an error message. @see Sql @see KaspaBase @see Table @see KaspaErr.
  */
class AuthorBase: public Table {
	private:
	AuthorBase(const AuthorBase&);
	AuthorBase& operator=(const AuthorBase&);

	public:
  /** Create new author. The fields are empty. The connection is initialized from
   *  an established connection (sharing) or the database with name dbname is opened
   *  Throws exceptions.
   */
  AuthorBase(Sql *conn);
  AuthorBase(const char *dbname);

  /** Reads row with the sql where clause where. It
   *  must not return more than one record. See above
   *  for connection parameters.
   *  Throws exceptions.
   */
  AuthorBase(const char *where, Sql *conn);
  AuthorBase(const char *where, const char *dbname);

  /** Destructor.
   *  Throws exceptions.
	 */
	 virtual ~AuthorBase();

  /** returns pointer to lastname, pointers are valid until deletion,
   * reset or destruction of the instance. The strings are guaranteed to
   * be not 0L. If the tuple is invalied (e.g. deleted) the strings are
   * empty ("").
   * Does not throw exceptions.
   */
  const char *getLastName();
  const char *getFirstName();
  const char *getPseudonym();
  const char *getBirthday();
  const char *getDay_of_Death();
  const char *getCountry();
  const char *getMemo();
	const char *getModified();
	const char *getCreated();
  const unsigned char *getPicture();
  long getPictureLength();
  /** Returns the publications associated with the author.
   * Throws exceptions.
   *  @see PublTitle
   */
  PublTitle *getPubl();
  /** Returns the parts (e.g. chapters) associated with the author.
   *  Throws exceptions.
   *  @see PartTitle
   */
  PartTitle *getParts();

  /** Sets the field lastname and mark it as changed. The string is copied.
   * Does not throw exceptions.
   */
  void setLastName(const char *s);
  void setFirstName(const char *s);
  void setPseudonym(const char *s);
  void setBirthday(const char *d);
  void setDay_of_Death(const char *d);
  void setCountry(const char *s);
  void setMemo(const char *s);
  void setPicture(const unsigned char *i, long l);

  Oid createNote();
  Oid createPubl();
  void insertPubl(Oid o);
  void removePubl(Oid o);

  void insertPart(Oid o);
  void removePart(Oid o);

  /** returns a pointer to the where clause matching the tuple.
   * Does not throw exceptions.
   */
  virtual const char *getWhereClause() { return _where; }

 private:
	void initNew();
	void initWhere(const char *where);
  /** Implemantation of pure virtual method @ref Table::read.
      It tries to read the author matching the where clause.
      If the author does not exist, the fields are emptied and
      the tuple is marked as invalid.
      Throws exceptions.
  */
  virtual KaspaRec *invalid();
  virtual KaspaRec *read(const char *where);
  /** Implementation of pure virtual method from @ref Table.
      It updates the fields marked changed. These fields marked
      as unchanged again.
      Throws exceptions.
  */
  virtual void write(const char *where, bool block=false);
  /** Implementation of the pure virtual method @ref Table::del.
      It deletes the tuple, empties all fields and set invalid state.
      Throws exceptions.
  */
  virtual void del(const Oid o);
  /** casts @ref Table::rec (of type @ref KaspaRec) to type @ref AuthorRec
      Does not throw exceptions.
   */
  AuthorRec *author();
  /** Called by constructors...  throw exceptions.*/
/*  void initNew();
  void initWhere(const char *where);	 */

  Str _where;
};

#endif AUTHORBASE_H