/***************************************************************************
                          cmaptoolpath.h
                      -------------------
    description          :
    begin                : Thu Nov 23 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMAPTOOLPATH_H
#define CMAPTOOLPATH_H

#include <qmsgbox.h>
#include "cmapwidget.h"
#include "cmaptoolbase.h"


static unsigned char path1_bits[] = {			// first path cursor bitmap
   0x10, 0x00, 0x30, 0x00, 0x70, 0x00, 0xf0, 0x00, 0xf0, 0x01, 0xf0, 0x03,
   0xf0, 0x07, 0xf0, 0x0f, 0xf0, 0x01, 0xf0, 0x03, 0xb0, 0x07, 0x12, 0x0f,
   0x03, 0x06, 0x02, 0x02, 0x02, 0x00, 0x07, 0x00};

static unsigned char path2_bits[] = {			// second path cursor bitmap
   0x10, 0x00, 0x30, 0x00, 0x70, 0x00, 0xf0, 0x00, 0xf0, 0x01, 0xf0, 0x03,
   0xf0, 0x07, 0xf0, 0x0f, 0xf0, 0x01, 0xf0, 0x03, 0xb0, 0x07, 0x12, 0x0f,
   0x05, 0x06, 0x04, 0x02, 0x02, 0x00, 0x07, 0x00};


/**The path creation tool
  *@author John-Paul Stanford
  */
class CMapToolPath : public CMapToolBase
{
public:
	CMapToolPath(CMapData *mapData,CMapWidget *map,int id, QString name,QPixmap icon, KToolBar *toolBar,QPopupMenu *menu) : CMapToolBase(mapData,map,id,name,icon,toolBar,menu)
	{
		QBitmap pathStart_cb(16,16, path1_bits,TRUE);
		pathStartCursor = new QCursor( pathStart_cb,pathStart_cb, 4,0);

		QBitmap pathEnd_cb(16,16, path2_bits,TRUE);
		pathEndCursor = new QCursor( pathEnd_cb, pathEnd_cb, 4,0);	
	
	}
	
	~CMapToolPath()
	{
		delete pathEndCursor;
		delete pathStartCursor;
	}
	
	/** This method is called when the mouse is pressed */
	void mousePressEvent(QMouseEvent *e);
	/** This method is called when the mouse is released */
	void mouseReleaseEvent(QMouseEvent *e);
	/** This method is called when the mouse is moved */
	void mouseMoveEvent(QMouseEvent *e);
	/** This function called when the path tool is selected */
	void toolSelected(void);
	/** This function is called when the path tool is unselected */
	void toolUnselected();
	
private:
	QCursor *pathStartCursor;
	QCursor *pathEndCursor;
	CMapRoom *pathStartRoom;
	int pathToolMode;
	
};

#endif
