/***************************************************************************
                          cmapundoelement.h
                      -------------------
    description          :
    begin                : Wed Feb 7 2001
    copyright            : (C) 2001 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMAPUNDOELEMENT_H
#define CMAPUNDOELEMENT_H

#include "cmaproom.h"

/**
  *@author Kevin Krammer
  */

class CMapUndoElement {
public:
  // possible values for flags, can be or'ed
  static const uint ROOM       = 1;  // a room was created
  static const uint LEVEL      = 2;  // a level was created
  static const uint PATH       = 4;  // a path was created
  static const uint BIDIR      = 8;  // path was created bidiretional

	CMapUndoElement();
	CMapUndoElement(CMapRoom* origin, direction dir, uint flags);
	~CMapUndoElement();
	
	void setRoom(CMapRoom* room);
	void setDirection(direction dir);
	void setAllFlags(uint flags);
	CMapRoom* getRoom();
	direction getDirection();
	uint getAllFlags();
	
	void setFlag(uint mask);
	void clearFlag(uint mask);
	bool isFlagSet(uint mask);
	
protected:
  uint flags_;
  CMapRoom* origin_;
  direction dir_;
};

#endif
