/***************************************************************************
                          kmudping.h
                      -------------------
    description          : Provide an interface for pinging host
    begin                : Mon Jul 31 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KMUDPING_H
#define KMUDPING_H

#include <qwidget.h>
#include <kprocess.h>
#include "dialogs/dlgpingprogress.h"

#define PING_NO_EXECUTABLE -1

/**
  *@author Kevin Krammer
  */

class KmudPing : public QObject {
  Q_OBJECT

public:
	KmudPing();
	~KmudPing();
	
	bool setExecutable(QString program);
	int execPingHostDlg(QWidget* parent, QString host, int ping_count=5);

public slots:
  void slotPingExited(KProcess* process);
  void slotKillPing();
  void slotPingOutput(KProcess*, char*, int);

signals:
  void pingExited(int status);
  void outputRecieved(QString output);

protected:
  KProcess ping;
  QString executable;
  DlgPingProgress* dialog;
};
#endif
