#ifndef KINVWND_H
#define KINVWND_H
#include <qpopupmenu.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qdialog.h>
#include "rogue/rogue.h"

object *objfirst(int mask, int inusemask=0);
object *objnext(object *obj, int mask, int inusemask=0);
char *objstr(object *obj, char *str);

class QListViewItem;
class QListView;
class QLineEdit;
class KItemLVI;

class KInvWnd:public QDialog
{
  Q_OBJECT
public:
  KInvWnd(QWidget *parent=NULL, const char *name=NULL, int amask=ALL_OBJECTS,
    bool select=false, object *rpack=NULL);
  void show(void);
  static QString useName(object *obj);
  static void doUse(object *obj);
  static int getObjIconId(object *obj);
public slots:
  virtual void selectbt(void);
  virtual void usebt(void);
  virtual void setusename(QListViewItem *);
  virtual void showPopup(QListViewItem *, const QPoint &);
protected:
  QPushButton *close, *use;
  QListView *lv;
  object *pack;
  int mask;
  void keyPressEvent(QKeyEvent *k);
  friend class KItemMenu;
};

class KItemMenu:public QPopupMenu
{
  Q_OBJECT
public:
  KItemMenu(KInvWnd *parent, KItemLVI *_lvi);
public slots:
  void fillPopup();
  void use();
  void call();
  void drop();
protected:
  int item;
  KItemLVI *lvi;
  KInvWnd *wnd;
};

class KInvPopup:public QPopupMenu
{
  Q_OBJECT
public:
  KInvPopup(int _mask, int _inusemask=0);
public slots:
  void fillPopup();
protected:
  int mask, inusemask;
};

class KNItemDlg:public QDialog
{
  Q_OBJECT
public:
  KNItemDlg(QWidget *);
public slots:
  void listclick(int i);
protected slots:
  void accept(void);
protected:
  QListBox *list1, *list2;
};

class KStrDlg:public QDialog
{
  Q_OBJECT
public:
  KStrDlg(const QString &q, bool pass=false, QWidget *parent=NULL, char *name=NULL);
  virtual ~KStrDlg(void) {}
  virtual QString text() {return le->text();}
protected:
  QLineEdit *le;
};

class KSellItemDlg:public QDialog
{
  Q_OBJECT
public: 
  KSellItemDlg(QWidget *parent=NULL, char *name=NULL);
  void show();
  virtual ~KSellItemDlg(void) {}
  virtual void add(const QString &text, int price);
protected:
  QListView *lv;
  QListViewItem *lastlvi;
  long egold;
};
#endif
