/***************************************************************************
                          kbeardirviewitem.cpp  -  description
                             -------------------
    begin                : Tue Jun 6 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbeardirviewitem.h"

//-----------------------------------------------
KBearDirViewItem::KBearDirViewItem( QListView *p, KFileViewItem* item, const QString &text, bool homeDir )
	: QListViewItem( p, text ),KFileViewItem(item->url().url( 1 ),
		((KFileItem*)item)->entry() ), parent(0), isHome( homeDir )
{
	isLocked = false;
	if( (isLocalFile() && QDir::homeDirPath() == url().path()) || isHome ) {
		pix = KGlobal::iconLoader()->loadIcon("folder_home", KIcon::Small );
		isHome = true;
	}
	else
		pix = item->pixmap();
	
	setPixmap( &pix );
}
//-----------------------------------------------
KBearDirViewItem::KBearDirViewItem( KBearDirViewItem *p, KFileViewItem* item, const QString &text )
	: QListViewItem ( p, text ),KFileViewItem(p->url().url( 1 ), ((KFileItem*)item)->entry() ),parent( p )
{
	isLocked = false;
	isHome = false;
	if( isLocalFile() && QDir::homeDirPath() == url().path() ) {
		pix = KGlobal::iconLoader()->loadIcon("folder_home", KIcon::Small );
		isHome = true;
	}
	else {
		(void) item->determineMimeType();
		pix = item->pixmap();
	}
	setPixmap( &pix );
}
//-----------------------------------------------
void KBearDirViewItem::setup() {
	setExpandable( true );
	QListViewItem::setup();
}
//-----------------------------------------------
void KBearDirViewItem::setPixmap( QPixmap *p ) {
	pix = *p;
	QListViewItem::setPixmap( 0, pix );
	setup();
	widthChanged( 0 );
	invalidateHeight();
	repaint();
}
//-----------------------------------------------
void KBearDirViewItem::setOpen( bool o ) {
	setOpenExt( o );
	if( o )
		((KBearDirView*)listView())->sendFolderStatusChanged( this );
	else
		((KBearDirView*)listView())->sendFolderStatusChanged( (QListViewItem*)parent );
}
//-----------------------------------------------
void KBearDirViewItem::setOpenExt( bool o ) {
	if ( isLocked ) {
		pix =  KGlobal::iconLoader()->loadIcon("folder_locked", KIcon::Small );
		setPixmap( &pix );
		setExpandable( false );
		return;
	}
	else if( isHome ){
		pix =  KGlobal::iconLoader()->loadIcon("folder_home", KIcon::Small );
		setPixmap( &pix );
	}
	else if( o ) {
		pix =  KGlobal::iconLoader()->loadIcon("folder_open", KIcon::Small );
		setPixmap( &pix );
	}
	else
		pix =  KGlobal::iconLoader()->loadIcon("folder", KIcon::Small );
		setPixmap( &pix );
	
	QListViewItem::setOpen( o );
}
//-----------------------------------------------

