/***************************************************************************
                          kbearfiledetailview.h  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARFILEDETAILVIEW_H
#define KBEARFILEDETAILVIEW_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
#include <qdragobject.h>
#include <qmime.h>
#include <qtimer.h>
#include <qstrlist.h>
#include <qpoint.h>
#include <qmessagebox.h>
#include <qlistview.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kfiledetailview.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <kapp.h>
//////////////////////////////////////////////////////
// application specific includes
#include <time.h>
class KBearDirOperator;


/**This is a fileview inherited from KFileDetailView.
	*It adds "drag and drop" handling to the view suitable for KBear
  *@author Bjrn Sahlstrm
**/
class KBearFileDetailView : public KFileDetailView  {
	Q_OBJECT
public: 
	/**  */
	KBearFileDetailView( QWidget* parent, const char *name=0);
	/**  */
	~KBearFileDetailView();
	/** Sets the @ref KBearDirOperator that operates for this view */
	virtual void setOperator(QObject *ops);

protected: //Protected Methods
	/**  */
	virtual void contentsDragEnterEvent( QDragEnterEvent *e );
	/**  */
	virtual void contentsDragMoveEvent( QDragMoveEvent *e );
	/**  */
	virtual void contentsDragLeaveEvent( QDragLeaveEvent *e );
	/**  */
	virtual void contentsDropEvent( QDropEvent* e );
	/** Creates the drag item and starts the drag */
	virtual void startDrag();

protected slots: // Protected slots
	/**  */
	void slotOpenFolder();
private: //Private Attributes
	QListViewItem* dropItem;
	QTimer myAutoOpenTimer;
	KBearDirOperator* myOp;
	QDragObject* myDragObject;
	QPoint mousePos;
};

#endif
