//***************************************************************************
//                          kbearfileiconview.cpp  -  description
//                             -------------------
//    begin                : Thu Jul 6 2000
//    copyright            : (C) 2000 by Bjrn Sahlstrm
//    email                : bjorn.sahlstrom@mail.bip.net
//***************************************************************************/

//***************************************************************************
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//***************************************************************************/

#include "kbearfileiconview.h"
#include "kbearftpview.h"

static const int autoOpenTime = 750;
//-----------------------------------------------
KBearFileIconView::KBearFileIconView( QWidget* p, const char *n )
 : KFileIconView(p,n), dropItem(0), myAutoOpenTimer(this)
{
	setAutoUpdate( true );
	setIconSize( KIcon::SizeMedium );
	arrangeItemsInGrid ( true );
	setItemTextPos( QIconView::Bottom );
	setArrangement( QIconView::LeftToRight );
	setResizeMode( QIconView::Adjust );
	setGridX( 75 );
	setAcceptDrops( true );
	viewport()->setAcceptDrops( true );
	connect( &myAutoOpenTimer, SIGNAL( timeout() ),	this, SLOT( slotOpenFolder() ) );
}
//-----------------------------------------------
KBearFileIconView::~KBearFileIconView(){
}
//-----------------------------------------------
void KBearFileIconView::slotOpenFolder(){
	myAutoOpenTimer.stop();
	if( !dropItem )
		return;
	const KFileViewItemList* fileList = KFileView::items();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	for( ; it.current() ;++it ){
		if( (*it)->name() == dropItem->text() && (*it)->isFile())
			return;
	}
	KURL url = myOp->url();
	url.cd( dropItem->text() );
	myOp->setURL( url.path( 1 ), true );
}
//-----------------------------------------------
void KBearFileIconView::contentsDragEnterEvent( QDragEnterEvent *e ) {
	setSelectionMode( KFile::Single );
	if ( QUriDrag::canDecode( e ) ) {
		e->accept( true );
		QIconViewItem *i = findItem( contentsToViewport( e->pos() ) );
		if ( i ) {
			dropItem = i;
			myAutoOpenTimer.start( autoOpenTime );
		}
	}
}
//-----------------------------------------------
void KBearFileIconView::contentsDragMoveEvent( QDragMoveEvent *e ) {
	if ( QUriDrag::canDecode( e ) ) {
		e->accept( true );
		QIconViewItem *i = findItem( contentsToViewport( e->pos() ) );
		if ( i ) {
			if ( i != dropItem ) {
				myAutoOpenTimer.stop();
				dropItem = i;
				myAutoOpenTimer.start( autoOpenTime );
			}
		}
		else
			myAutoOpenTimer.stop();
	}
}
//-----------------------------------------------
void KBearFileIconView::contentsDragLeaveEvent( QDragLeaveEvent* ) {
	myAutoOpenTimer.stop();
	dropItem = 0;
	setSelectionMode( KFile::Extended );
}
//-----------------------------------------------
void KBearFileIconView::contentsDropEvent( QDropEvent* e ) {
	setSelectionMode( KFile::Extended );
	myAutoOpenTimer.stop();
	dropItem = 0;
	KFileIconView::contentsDropEvent( e );
	myOp->myFtpView()->dropped( e );
}
//-----------------------------------------------
void KBearFileIconView::startDrag(){
	if ( ! currentItem() )
		return;
	dragObject();
	myDragObject->setPixmap( *currentItem()->pixmap(),
 		     								QPoint( currentItem()->pixmapRect().width() / 2,
 		     								currentItem()->pixmapRect().height() / 2 ) );
	myDragObject->dragCopy();   // start the drag
}
//-----------------------------------------------
QDragObject* KBearFileIconView::dragObject() {
	myDragObject = new KBearFileIconDrag( viewport(), "MyIconDrag" );
	QPoint orig = viewportToContents( viewport()->mapFromGlobal( QCursor::pos() ) );
	QStringList lst;
	const KFileViewItemList* fileList = KFileView::selectedItems();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	
	for ( ; it.current(); ++it ){
		QIconDragItem id;
		id.setData( QCString( (*it)->name() ) );
		KFileIconViewItem* i = (KFileIconViewItem*)(*it);
		((KBearFileIconDrag*)myDragObject)->append( id,
				QRect( i->pixmapRect( false ).x() - orig.x(),
				i->pixmapRect( false ).y() - orig.y(),
				i->pixmapRect().width(), i->pixmapRect().height() ),
				QRect( i->textRect( false ).x() - orig.x(),
				i->textRect( false ).y() - orig.y(),
				i->textRect().width(), i->textRect().height() ),
				QString( (*it)->url().prettyURL() ));
	}
	return myDragObject;
}
//-----------------------------------------------
void KBearFileIconView::setOperator(QObject *ops) {
	KFileView::setOperator( ops );
	myOp = (KBearDirOperator*)ops;
}
//-----------------------------------------------
