/***************************************************************************
                          kbearquickconnectdata.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qtooltip.h>
#include <qfont.h>
#include "kbearquickconnect.h"

void  KBearQuickConnect::initDialog(){
  this->resize(360,250);
  this->setMinimumSize(0,0);
  this->setFocus();
  UrlLabel= new QLabel(this,"UrlLabel");
  UrlLabel->setGeometry(10,10,70,20);
  UrlLabel->setMinimumSize(0,0);
  UrlLabel->setText("URL:");

  HostNameEdit= new QLineEdit(this,"HostNameEdit");
  HostNameEdit->setGeometry(80,10,230,20);
  HostNameEdit->setMinimumSize(0,0);
  QToolTip::add(HostNameEdit,"Enter URL to remote host here");
  HostNameEdit->setFocus();
  HostNameEdit->setText("");

  PortLabel= new QLabel(this,"PortLabel");
  PortLabel->setGeometry(10,40,60,20);
  PortLabel->setMinimumSize(0,0);
  PortLabel->setText("Port:");

  PortSpinBox= new QSpinBox(this,"PortSpinBox");
  PortSpinBox->setGeometry(80,40,50,20);
  PortSpinBox->setMinimumSize(0,0);
  QToolTip::add(PortSpinBox,"Select port here");
  PortSpinBox->setRange(0,500);
  PortSpinBox->setValue(21);

  AnonymousCheck= new QCheckBox(this,"AnonymousCheck");
  AnonymousCheck->setGeometry(170,40,130,20);
  AnonymousCheck->setMinimumSize(0,0);
  AnonymousCheck->setText("Anonymous login");

  UserNameLabel= new QLabel(this,"UserNameLabel");
  UserNameLabel->setGeometry(10,70,70,20);
  UserNameLabel->setMinimumSize(0,0);
  UserNameLabel->setText("Username:");

  UserNameEdit= new QLineEdit(this,"UserNameEdit");
  UserNameEdit->setGeometry(80,70,230,20);
  UserNameEdit->setMinimumSize(0,0);
  QToolTip::add(UserNameEdit,"Enter your user name here\nIf you leave this empty anonymous login is expected!!!");
  UserNameEdit->setText("");

  PasswordLabel= new QLabel(this,"PasswordLabel");
  PasswordLabel->setGeometry(10,100,70,20);
  PasswordLabel->setMinimumSize(0,0);
  PasswordLabel->setText("Password:");

  PasswordEdit= new QLineEdit(this,"PasswordEdit");
  PasswordEdit->setGeometry(80,100,230,20);
  PasswordEdit->setMinimumSize(0,0);
  QToolTip::add(PasswordEdit,"Enter your password here");
  PasswordEdit->setText("");

  RemoteDirLabel= new QLabel(this,"RemoteDirLabel");
  RemoteDirLabel->setGeometry(10,130,70,20);
  RemoteDirLabel->setMinimumSize(0,0);
  RemoteDirLabel->setText("Remote Dir:");

  RemoteDirEdit= new QLineEdit(this,"RemoteDirEdit");
  RemoteDirEdit->setGeometry(80,130,230,20);
  RemoteDirEdit->setMinimumSize(0,0);
  QToolTip::add(RemoteDirEdit,"Enter start directory on remote host here");
  RemoteDirEdit->setText("");

  saveToSiteManagerCheckBox= new QCheckBox(this,"SaveToSiteManagerCheckBox");
  saveToSiteManagerCheckBox->setGeometry(80,160,131,19);
  saveToSiteManagerCheckBox->setMinimumSize(0,0);
  saveToSiteManagerCheckBox->setText(i18n("Save to Sitemanager"));
  saveToSiteManagerCheckBox->setChecked( false );
  saveToSiteManagerCheckBox->setAutoResize(true);

  ConnectButton= new QPushButton(this,"ConnectButton");
  ConnectButton->setGeometry(80,200,90,40);
  ConnectButton->setMinimumSize(0,0);
  QToolTip::add(ConnectButton,"Press button to connect");
  ConnectButton->setFont(QFont("helvetica", 18, 50));
  ConnectButton->setText("Connect");
  ConnectButton->setDefault(true);
  ConnectButton->setAutoDefault(true);

  CancelButton= new QPushButton(this,"CancelButton");
  CancelButton->setGeometry(220,200,90,40);
  CancelButton->setMinimumSize(0,0);
  QToolTip::add(CancelButton,"Press button to cansel and exit dialog");
  CancelButton->setFont(QFont("helvetica", 18, 50));
  CancelButton->setText("Cancel");
}
