/***************************************************************************
                          kbearsitemanager.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KBEAR_SITEMANAGER_H
#define KBEAR_SITEMANAGER_H

/////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
#include <qlistview.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qmultilinedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qwhatsthis.h>
#include <qfile.h>
#include <qstring.h>
#include <qtextstream.h>
/////////////////////////////////////////////////////
// KDE specific includes
#include <kmessagebox.h>
#include <klocale.h>
#include <kapp.h>
#include <kurl.h>
#include <kstddirs.h>
#include <klineeditdlg.h>
/////////////////////////////////////////////////////
// Application specific includes
#include "kbeartreeview.h"
#include "kbearsitemanagermap.h"
#include "kbearsitemanagertreeview.h"

class KBearSiteManagerMap;
/**
  *@author Bjrn Sahlstrm
  */
class KBearSiteManager : public QWidget  {
   Q_OBJECT

public:
	/**  */
	KBearSiteManager(QWidget *parent=0, const char *name=0);
	/**  */
	~KBearSiteManager();
	/**  */
	void setConnectEnabled( bool enable );
	/**  */
	SiteInfo* selectedSite( const QString& name );
	/**
	*Adds a new group to the tree view
	*@param parent should contain the parent item for the group or 0 if root
	*@param name should contain the name for the new grou, this have to be unique
	*/
	void addGroup( QListViewItem* parent, const QString& name, SiteInfo& siteInf ) ;
	/**
	*Checks if the name already exists in the sitemanager
	*@param name is the name to check
	*@return true if name exist or false if not
	*/
 	bool checkNameIntegrity( const QString& name );
  /**  */
  void saveSite( const SiteInfo& siteInfo );
signals:
	/**  */
	void remoteConnect( ConnectInfo& );
	/**  */
	void close();
protected slots: // Protected slots
	/**  */
	void slotActivatedMenu( QListViewItem*, const QPoint&, int );
	void init();
  /**
  *removes a site from site list
  */
  void slotRemoveButton();
  /**
  *add a new site to site list
  */
  void slotNewButton();
  /**
  *connect to selected site
  */
  void slotConnectButton();
  /**
  *save the edited site to the sitelist
  */
  void slotSaveButton();
  /**
  *close the SiteManager
  */
  void slotCancelButton();
  /**
  *enables editing
  */
  void slotDirButton();
  /**
  *display information from selected site
  */
  void slotSelectedSite(QListViewItem *);
  /**  */
  void slotRenameSite();
  /**
  *Called when the signal @ref KListView::moved is emitted
  *Note: the item may not be placed exactly where it was dropped because the
  *items are automatically sorted, but it will still be in same level as it was dropped
  */
  void slotMoved (QListViewItem *item, QListViewItem *afterFirst, QListViewItem *afterNow);
protected: // Protected methods
	/**  */
	void removeSite( QListViewItem* item );
	/**
	* sets up the GUI
	*/
	void initDialog();
	/**
	*reset all input fields
	*/
	void clearView();
  /**  */
  bool checkValidName( const QString& name );
	/**  */
	void writeFile( const QString& file );
	/**  */
	void readFile( const QString& file );
private slots: //Private slots
	void setEdited();
private: //Private methods
	void createGroupTree( QListViewItem* parent );
protected: //Protected attributes
	KBearTreeView *siteTreeView;
	QGroupBox *groupBox;
	QLineEdit *siteEdit;
	QLabel *siteLabel;
	QLabel *hostNameLabel;
	QLineEdit *hostNameEdit;
	QLabel *portLabel;
	QSpinBox *portSpinBox;
	QLabel *descriptionLabel;
	QMultiLineEdit *descriptionEdit;
	QLabel *userNameLabel;
	QComboBox *userNameEdit;
	QLabel *passwordLabel;
	QLineEdit *passwordEdit;
	QLabel *defaultDirLabel;
	QLineEdit *defaultDirEdit;
	QCheckBox *anonymousCheck;
	QPushButton *cancelButton;
	QPushButton *saveButton;
	QPushButton *connectButton;
	QPushButton *newButton;
	QPushButton *removeButton;
	QPushButton *dirButton;

private: //Private attributes
	bool newSite;
	QString fileName;
	KBearSiteManagerMap mySiteMap;	
};
#endif
