/***************************************************************************
                          kbearfiledetailview.cpp  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbearfiledetailview.h"

//-----------------------------------------------
KBearFileDetailView::KBearFileDetailView( QWidget* p, const char *n )
 :	KFileDnDDetailView( p, n )
{
	setAutoUpdate( true );
	QObject::connect( this, SIGNAL( openFolder( const QString ) ), SLOT( slotOpenFolder( const QString ) ) );
}
//-----------------------------------------------
KBearFileDetailView::~KBearFileDetailView(){
}
//-----------------------------------------------
void KBearFileDetailView::slotOpenFolder( const QString folderName ){
	KURL url = myOp->url();
	url.cd( folderName );
	myOp->setURL( url.path( 1 ), true );
}
//-----------------------------------------------
void KBearFileDetailView::setOperator(QObject *ops) {
	KFileView::setOperator( ops );
	myOp = (KBearDirOperator*)ops;
}
//-----------------------------------------------
void KBearFileDetailView::keyPressEvent(QKeyEvent* e) {
	if( e->key() == Key_M && e->state() == ControlButton) {
		KFileViewItem* item = ((QList<KFileViewItem>*)KFileView::selectedItems())->first();
		activateMenu( item ? item : 0L );
	}
	KListView::keyPressEvent( e );
}
//-----------------------------------------------

