/***************************************************************************
                          legenditem.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Tue Aug 31 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <ksimpleconfig.h>
#include "legenditem.h"
#include "legenddlg.h"
#include "kplchecklistitem.h"
#include "kplgraph.h"
#include "utils.h"

LegendItem::LegendItem()
{
}

LegendItem::LegendItem(Kpl::AutoStruct* aut) : symb(aut->autoSymb),
 colsymb(aut->colData), coltext(aut->colFrame), relsiz(1.0)
{
  double dx = aut->xlAuto / 15.0;
  x = aut->x0Auto + dx;
  y = aut->y0Auto + aut->ylAuto - (++aut->nyLeg) * dx;
  xtext = dx;
  ytext = -0.18 * dx;
}

LegendItem::LegendItem(KSimpleConfig* plo, Kpl::AutoStruct* aut) : KplItem(plo)
{
  symb = plo->readNumEntry("symb", aut->autoSymb);
  char s1[256];
  strcpy(s1, plo->readEntry("colsymb", ""));
  unsigned u;
  if (strlen(s1)) {
    sscanf(s1, "%x", &u);
    colsymb = Utils::rgbQt(u);
  } else
    colsymb = aut->colData;
  strcpy(s1, plo->readEntry("coltext", ""));
  if (strlen(s1)) {
    sscanf(s1, "%x", &u);
    coltext = Utils::rgbQt(u);
  } else
    coltext = aut->colFrame;
  double dx = aut->xlAuto / 15.0;
  x = plo->readDoubleNumEntry("x", aut->x0Auto + dx);
  y = plo->readDoubleNumEntry("y", aut->y0Auto + aut->ylAuto -
                              (++aut->nyLeg) * dx);
  xtext = plo->readDoubleNumEntry("xtext", dx);
  ytext = plo->readDoubleNumEntry("ytext", -0.18 * dx);
  relsiz = plo->readDoubleNumEntry("relsiz", 1.0);
  s = plo->readEntry("s", "");
}

LegendItem::LegendItem(bool act, int sym, const QString& colSymb,
                       const QString& colText, double x0, double y0,
                       double xoff, double yoff, double relSize,
                       const QString& text) :
 symb(sym), x(x0), y(y0), xtext(xoff), ytext(yoff), relsiz(relSize), s(text)
{
  active = act;
  unsigned u;
  sscanf(colSymb.latin1(), "%x", &u);
  colsymb = Utils::rgbQt(u);
  sscanf(colText.latin1(), "%x", &u);
  coltext = Utils::rgbQt(u);
}

LegendItem::~LegendItem()
{
}

KplItem::ItemTypes LegendItem::iType() const
{
  return Legend;
}

void LegendItem::draw(KplGraph* g) const
{
  if (active) {
    g->setColData(colsymb);
    g->setSymbol(symb);
    int n;
    double xa[2], ya[2];
    if (symb > 0) {
      g->cm2r(x - 0.4 * xtext, y, 1.0, 1.0, &xa[0], &ya[0]);
      g->cm2r(x + 0.4 * xtext, y, 1.0, 1.0, &xa[1], &ya[1]);
      n = 2;
    } else {
      g->cm2r(x, y, 1.0, 1.0, &xa[0], &ya[0]);
      n = 1;
    }
    g->plArray(xa, ya, 1.0, 1.0, n);
    g->setColFrame(coltext);
    double sav = g->setRelSize(relsiz);
    g->textcm(s, x + xtext, y + ytext, 1);
    g->setRelSize(sav);
  }
}

void LegendItem::writePlo(FILE* f, const KURL& url, bool abs) const
{
  fprintf(f, "Type=LEGENDITEM\n");
  KplItem::writePlo(f, url, abs);
  QString s2(s);
  fprintf(f, "symb=%i\ncolsymb=%x\ncoltext=%x\nx=%g\ny=%g\n"
          "xtext=%g\nytext=%g\nrelsiz=%g\ns=%s\n",
          symb, Utils::rgbQt1(colsymb), Utils::rgbQt1(coltext), x, y,
          xtext, ytext, relsiz, s2.utf8().data());
}

void LegendItem::setText(KplCheckListItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Legend"));
  it->setText(2, i18n("symbol") + " " + QString::number(symb));
}

int LegendItem::editItem(QWidget* parent, KplDoc* m, int)
{
  LegendDlg dlg(parent, m, this);
  return dlg.exec();
}

KplItem* LegendItem::copy() const
{
  return new LegendItem(*this);
}
