/***************************************************************************
                          symboldlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <klocale.h>
#include <kiconloader.h>
#include "kplspinbox.h"
#include "symboldlg.h"

SymbolButton::SymbolButton(QWidget* parent, KplSpinBox* sb) :
 QPushButton(parent), symb(sb)
{
  setButtonSymbol(symb->value());
  connect(symb, SIGNAL(valueChanged(int)), SLOT(setButtonSymbol(int)));
  connect(this, SIGNAL(clicked()), SLOT(slotSymbol()));
}

SymbolButton::~SymbolButton()
{
}

void SymbolButton::setButtonSymbol(int isymb)
{
  QString s;
  if (isymb > 0)
    setPixmap(BarIcon(s.sprintf("line%i", isymb)));
  else
    if (isymb == -17)
      setPixmap(0);
    else
      setPixmap(BarIcon(s.sprintf("symb%i", -isymb)));
}

void SymbolButton::slotSymbol()
{
  SymbolDlg dlg(parentWidget(), symb);
  dlg.exec();
}

SymbolDlg::SymbolDlg(QWidget* parent, KplSpinBox* sb0) :
 QDialog(parent, 0, true), sb(sb0)
{
  setCaption(i18n("Lines and markers"));
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  QHBoxLayout* hbox = new QHBoxLayout(vbox, 6);
  QGroupBox* g1 = new QGroupBox(0, Qt::Vertical, i18n("Lines"), this);
  hbox->addWidget(g1);
  QGroupBox* g2 = new QGroupBox(0, Qt::Vertical, i18n("Markers"), this);
  hbox->addWidget(g2);
  QGridLayout* grid = new QGridLayout(g2->layout(), 9, 5, 6);
  bg = new QButtonGroup();
  QRadioButton* r;
  QLabel* l;
  QString s;
  for (int i = 17; i >= 0; i--) {
    int ix = 3 * (i / 9);
    int iy = i % 9;
    grid->addWidget(r = new QRadioButton(QString::number(-i), g2),
                    iy, ix + 1);
    bg->insert(r);
    if (i == 17)
      continue;
    grid->addWidget(l = new QLabel(g2), iy, ix);
    l->setPixmap(BarIcon(s.sprintf("symb%i", i)));
  }
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding),
                 0, 2);
  grid = new QGridLayout(g1->layout(), 9, 2, 6);
  for (int i = 0; i < 9; i++) {
    grid->addWidget(r = new QRadioButton(QString::number(i + 1), g1), i, 1);
    bg->insert(r);
    grid->addWidget(l = new QLabel(g1), i, 0);
    l->setPixmap(BarIcon(s.sprintf("line%i", i + 1)));
  }
  ((QRadioButton*) bg->find(sb->interpretedValue() + 17))->setChecked(true);
  hbox = new QHBoxLayout(vbox, 6);
  QPushButton* b = new QPushButton(i18n("OK"), this);
  hbox->addWidget(b);
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(slotOK()));
  hbox->addWidget(b = new QPushButton(i18n("Cancel"), this));
  connect(b, SIGNAL(clicked()), SLOT(reject()));
}

SymbolDlg::~SymbolDlg()
{
  delete bg;
}

void SymbolDlg::slotOK()
{
  int i = -1;
  QRadioButton* rb;
  do
    rb = (QRadioButton*) bg->find(++i);
  while (!rb->isChecked());
  sb->setValue(i - 17);
  accept();
}
