/***************************************************************************
                          arrowdlg.cpp  -  description
                             -------------------
    begin                : Sat Apr 14 2001
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <kapp.h>
#include "arrowdlg.h"
#include "arrowitem.h"
#include "kpldoubleedit.h"

ArrowDlg::ArrowDlg(QWidget* parent, KplDoc* model, ArrowItem* ad0, int nrows) :
 DecoDlg(parent, model, ad0, nrows), ad(ad0)
{
  resize(400, 140);
  setCaption(i18n("Arrow"));
  initPolarEntries(this, ad, grid, &eDir, &eLen);
  initEntries(1);
  initButtons();
  connect(bHelp, SIGNAL(clicked()), SLOT(slotHelp()));
  connect(bOK, SIGNAL(clicked()), SLOT(slotOK()));
  connect(bApply, SIGNAL(clicked()), SLOT(slotApply()));
}

ArrowDlg::~ArrowDlg()
{
}

void ArrowDlg::initPolarEntries(QWidget* parent, ArrowItem* ad,
                                QGridLayout* grid, KplDoubleEdit** eDir,
                                KplDoubleEdit** eLen)
{
  grid->addWidget(new QLabel(i18n("Direction"), parent), 0, 0);
  grid->addWidget(*eDir = new KplDoubleEdit(ad->dir, -360.0, 360.0, parent),
                  0, 1);
  grid->addWidget(new QLabel("", parent), 0, 2);
  grid->addWidget(new QLabel(i18n("Length"), parent), 0, 4);
  grid->addWidget(*eLen = new KplDoubleEdit(ad->len, 0.0, 200.0, parent), 0, 5);
  grid->addWidget(new QLabel("cm", parent), 0, 6);
}

void ArrowDlg::getValues(bool ok)
{
  ad->dir = eDir->value();
  ad->len = eLen->value();
  DecoDlg::getValues(ok);
}

void ArrowDlg::slotOK()
{
  getValues(true);
}

void ArrowDlg::slotApply()
{
  getValues(false);
}

void ArrowDlg::slotHelp()
{
  kapp->invokeHelp("SEC-ARROW");
}
