/***************************************************************************
                          basicdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qgroupbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include <kapp.h>
#include <kcolorbtn.h>
#include "basicdlg.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"

BasicDlg::BasicDlg(QWidget* parent, Kpl::AutoStruct* bs) :
 QDialog(parent, 0, true), b(bs)
{
  resize(330, 370);
  setCaption(i18n("Basic settings"));
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, i18n("Page format "), this);
  vbox->addWidget(g);
  QVBoxLayout* vbox2 = new QVBoxLayout(g->layout(), 6);
  QHBoxLayout* hbox = new QHBoxLayout(vbox2, 6);
  hbox->addWidget(new QLabel(i18n("Width"), g));
  hbox->addWidget(formatx = new KplDoubleEdit(b->xf, 0.5, 200.0, g));
  hbox->addWidget(new QLabel("cm", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(new QLabel(i18n("Height"), g));
  hbox->addWidget(formaty = new KplDoubleEdit(b->yf, 0.5, 200.0, g));
  hbox->addWidget(new QLabel("cm", g));
  hbox = new QHBoxLayout(vbox2, 6);
  QPushButton* bn = new QPushButton(i18n("Portrait A4"), g);
  hbox->addWidget(bn);
  connect(bn, SIGNAL(clicked()), SLOT(slotPortrait()));
  hbox->addWidget(bn = new QPushButton(i18n("Landscape A4"), g));
  connect(bn, SIGNAL(clicked()), SLOT(slotLandscape()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Default colors"),
                                    this));
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 3, 6);
  grid->addWidget(new QLabel(i18n("Frame"), g), 0, 0);
  grid->addWidget(colFrame = new KColorButton(QColor(b->colFrame), g),
                  0, 1);
  grid->addWidget(new QLabel(i18n("Grid"), g), 1, 0);
  grid->addWidget(colGrid = new KColorButton(QColor(b->colGrid), g), 1, 1);
  grid->addWidget(new QLabel(i18n("Data"), g), 2, 0);
  grid->addWidget(colData = new KColorButton(QColor(b->colData), g), 2, 1);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Output format"),
                                    this));
  grid = new QGridLayout(g->layout(), 2, 3, 6);
  grid->addWidget(new QLabel(i18n("Presentation"), g), 0, 0);
  grid->addWidget(pres = new QComboBox(true, g), 0, 1);
  const char* items[] = {"e", "E", "f", "g", "G", 0};
  pres->insertStrList(items);
  int i;
  for (i = 0; i < 5; i++)
    if (*items[i] == b->format)
      break;
  pres->setCurrentItem(i);
  grid->addWidget(new QLabel(i18n("Precision"), g), 1, 0);
  grid->addWidget(prec = new KplSpinBox(0, 0, 1, g), 1, 1);
  prec->setRange(1, 30);
  prec->setValue(b->prec);
  hbox = new QHBoxLayout(vbox, 6);
  hbox->addWidget(bn = new QPushButton(i18n("Help"), this));
  connect(bn, SIGNAL(clicked()), SLOT(slotHelp()));
  hbox->addItem(new QSpacerItem(10, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(bn = new QPushButton(i18n("OK"), this));
  bn->setDefault(true);
  connect(bn, SIGNAL(clicked()), SLOT(slotOK()));
  hbox->addWidget(bn = new QPushButton(i18n("Cancel"), this));
  connect(bn, SIGNAL(clicked()), SLOT(reject()));
}

BasicDlg::~BasicDlg()
{
}

void BasicDlg::slotPortrait()
{
  formatx->setText("21.00");
  formaty->setText("29.70");
}

void BasicDlg::slotLandscape()
{
  formatx->setText("29.70");
  formaty->setText("21.00");
}

void BasicDlg::slotOK()
{
  b->xf = formatx->value();
  b->yf = formaty->value();
  b->colFrame = colFrame->color().rgb();
  b->colGrid = colGrid->color().rgb();
  b->colData = colData->color().rgb();
  b->format = *pres->currentText();
  b->prec = prec->interpretedValue();
  accept();
}

void BasicDlg::slotHelp()
{
  kapp->invokeHelp("SEC-BASIC");
}
