/***************************************************************************
                          refreshdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <klocale.h>
#include <kseparator.h>
#include "kplspinbox.h"
#include "refreshdlg.h"

RefreshDlg::RefreshDlg(QWidget* parent) : QDialog(parent, 0, true)
{
  setCaption(i18n("Reload periodically"));
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  QHBoxLayout* hbox = new QHBoxLayout(vbox, 6);
  hbox->addWidget(new QLabel(i18n("Interval"), this));
  hbox->addWidget(dt = new KplSpinBox(1, 600, 1, this));
  dt->setSuffix(" s");
  hbox->addWidget(activate = new QCheckBox(i18n("Activate"), this));
  connect(activate, SIGNAL(toggled(bool)), dt, SLOT(setEnabled(bool)));
  vbox->addWidget(new KSeparator(KSeparator::HLine, this));
  hbox = new QHBoxLayout(vbox, 6);
  QPushButton* b = new QPushButton(i18n("OK"), this);
  hbox->addWidget(b);
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(accept()));
  hbox->addWidget(b = new QPushButton(i18n("Cancel"), this));
  connect(b, SIGNAL(clicked()), SLOT(reject()));
}

RefreshDlg::~RefreshDlg()
{
}

void RefreshDlg::setWidgets(int tRef, bool act)
{
  activate->setChecked(act);
  dt->setValue(tRef);
  dt->setEnabled(act);
}

void RefreshDlg::getValues(int* tRef, bool* act) const
{
  *tRef = dt->interpretedValue();
  *act = activate->isChecked();
}
