#ifndef __KWOCHENSPRUCH__H
#define __KWOCHENSPRUCH__H

#include <qwidget.h>
#include <qlabel.h>
#include <qdatetime.h>
#include <qtextview.h>
#include <ksimpleconfig.h>
#include <kstddirs.h>
#include <qpixmap.h>
#include <qpopupmenu.h>

#include "harray.h"

class kaphorism_widget;

class spruch_widget : public QLabel
{
  private:
    kaphorism_widget *aphorism;
    QFont *font,*authorFont;
    QLabel *author;
  private:
    void layoutSpreuk(QString & spreuk,QString & author);
  public:
    spruch_widget(QWidget *parent,QString spreuk,QString author,kaphorism_widget *w);
   ~spruch_widget();
  protected:
    virtual void mouseReleaseEvent(QMouseEvent *e);
};

class kaphorism_widget : public QWidget
{
  Q_OBJECT
  private:
    bool           displayed;
    spruch_widget *spruch;
    QPopupMenu    *menu;
  public:
    bool           closed;
  public:
    kaphorism_widget(QWidget *parent=0);
   ~kaphorism_widget();
  protected:
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void paintEvent(QPaintEvent *e);
  protected:
    virtual QString  gebeSpruch(void);
    virtual QString  gebeAuteur(void);
    virtual QPixmap * pixmap(void);
  protected:
    virtual void     loadNew(QString choice);
    virtual QString  choice(int i);
    virtual void     choose(QString choice);
  protected slots:
    void quit(void);
    void about(void);
    void choose(int);
  protected:
    void setChoices(void);
};

class kaphorism : public kaphorism_widget
{
  class spreuk { 
    public:
      int from,to; 
      QString spreuk; 
  };
  private:
    QDate              datum;
    KSimpleConfig     *aphorisms;
    KConfigBase       *conf;
    harray<spreuk>     spreuken;
    harray<QString>    choices;
    QString            current;
    bool               loaded;
    QString            author,title;
    QPixmap           *pic;
  public:
    void load(QString file);
    void load(void);
  public:
    kaphorism(KConfigBase *cnf,QWidget *parent=0);
   ~kaphorism();
  protected:
    virtual QString  gebeSpruch(void);
    virtual QString  gebeAuteur(void);
    virtual QPixmap *pixmap(void);
    virtual QString  choice(int i);
    virtual void     loadNew(QString choice);
    virtual void     choose(QString choice);
};

#endif
