/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_


#include <qmap.h>
#include <kmainwindow.h>

#include "commitdlg.h"
#include "checkoutdlg.h"
#include "watchdlg.h"
#include "tagdlg.h"


class QLabel;
class QSplitter;
class QTimer;
class KAccel;
class UpdateView;
class ProtocolView;


class TopLevel : public KMainWindow
{
    Q_OBJECT

public:

    TopLevel(const char *name=0);
    ~TopLevel();

    void openSandbox(const QString &dirname);
    //    void parseStatus(QString pathname, QStrList list);
    void restorePseudo(const QString &dirname);
    
protected:
    virtual void readProperties(KConfig *config);
    virtual void saveProperties(KConfig *config);
    virtual bool queryExit();

private slots:
    void openFile(QString filename);
    void openFiles(const QStringList &filenames);
    void popupRequested();
    void updateMenu();
    void fillRecentPopup();
    void recentActivated(int n);
    void showMenuToolTip(int id);
    void aboutCervisia();

    void slotOpenSandbox();
    void slotOpen();
    void slotResolve();
    void slotStatus();
    void slotUpdate();
    void slotChangeLog();
    void slotCommit();
    void slotAdd();
    void slotAddBinary();
    void slotRemove();
    void slotRevert();
    void slotExit();
    void slotBrowseLog();
    //    void slotBrowseMultiLog();
    void slotAnnotate();
    void slotDiff();
    void slotLastChange();
    void slotHistory();
    void slotCheckout();
    void slotImport();
    void slotRepositories();
    void slotCreateTag();
    void slotDeleteTag();
    void slotUpdateToTag();
    void slotUpdateToHead();
    void slotMerge();
    void slotAddWatch();
    void slotRemoveWatch();
    void slotShowWatchers();
    void slotEdit();
    void slotUnedit();
    void slotShowEditors();
    void slotLock();
    void slotUnlock();
    void slotMakePatch();
    void slotCreateDirs();
    void slotPruneDirs();
    void slotHideFiles();
    void slotHideUpToDate();
    void slotHideRemoved();
    void slotUpdateRecursive();
    void slotCommitRecursive();
    void slotDoCVSEdit();
    void slotConfigure();
    void slotConfigureKeys();
    void slotHelp();
    void slotCVSInfo();
    void slotJobFinished(bool /*success*/);

private:    
    void setupAccel();
    void updateAccel();
    void setupMenuBar();
    void setupToolBar();
    void setupStatusBar();
    void setupToolTips();

    void updateOrStatus(bool noact, const QString &extraopt);
    void commitOrAddOrRemove(CommitDialog::ActionType action);
    void addOrRemoveWatch(WatchDialog::ActionType action);
    void importOrCheckout(CheckoutDialog::ActionType action);
    void createOrDeleteTag(TagDialog::ActionType action);
    void showJobStart(const QString &command);
    void setFilter();

    QPopupMenu *file, *recent, *view, *settings, *repo, *advanced, *help;
    UpdateView *update;
    ProtocolView *protocol;
    QSplitter *splitter;
    QTimer *timer;
    KAccel *accel;
    QMap<int, QString> tooltips;
    int file_sandbox, file_recent;
    int file_open, file_resolv;
    int file_update, file_status;
    int file_chlog, file_commit;
    int file_add, file_addbin, file_remove, file_revert, file_exit;
    int view_mlog, view_log, view_anno, view_diff, view_change, view_history;
    int view_desel, view_unfold, view_fold;
    int advanced_createtag, advanced_deltag, advanced_uptag, advanced_uphead, advanced_merge;
    int advanced_addwatch, advanced_remwatch, advanced_watchers;
    int advanced_edit, advanced_unedit, advanced_editors;
    int advanced_lock, advanced_unlock, advanced_patch;
    int repo_checkout, repo_import, repo_repos;
    int settings_hidefiles, settings_hideuptodate, settings_hideremoved;
    int settings_create, settings_prune;
    int settings_updaterecur, settings_commitrecur, settings_docvsedit;
    int settings_configure, settings_keys;
    int help_contents, help_cvsinfo, help_about;

    QLabel *filterLabel;
    QString sandbox;
    QString repository;

    QString changelogstr;
    QStringList recentFiles;
    QStringList recentCommits;
    bool opt_hideFiles, opt_hideUpToDate, opt_hideRemoved;
    bool opt_createDirs, opt_pruneDirs;
    bool opt_updateRecursive, opt_commitRecursive, opt_doCVSEdit;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
