/*
     File: khronodisplay.cpp
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "khronodisplay.h"
#include "khronotimer.h"
#include "khronotimedisplay.h"
#include "khronostatepanel.h"
#include "khronodatedisplay.h"
#include <qcolor.h>
#include <stdio.h>

const QColorGroup* KhronoDisplay::defaultTheme=new QColorGroup(
  QColor(0, 255, 0), black, black, QColor(0, 127, 0), black, black, black);

// *** Constructeurs *** //

KhronoDisplay::KhronoDisplay( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
  lcdTime=new KhronoTimeDisplay( this, "lcd_time" );
  lcdTime->setSegmentStyle(QLCDNumber::Flat);
  lcdTime->setPalette(QPalette(*defaultTheme, *defaultTheme, *defaultTheme));
  lcdDate=new KhronoDateDisplay( this, "lcd_date" );
  lcdDate->setPalette(QPalette(*defaultTheme, *defaultTheme, *defaultTheme));
  statePanel=new KhronoStatePanel( this, "state_panel" );
  statePanel->setMinimumHeight(40);
  statePanel->setMaximumHeight(40);
  statePanel->setPalette(QPalette(*defaultTheme, *defaultTheme, *defaultTheme));
  layout=new QVBoxLayout( this );
  layout->addWidget( lcdTime, 2 );
  layout->addWidget( lcdDate, 1 );
  layout->addWidget( statePanel );
  QObject::connect(lcdTime->getTimer(), SIGNAL(started(bool)),
                   statePanel, SLOT(setStart(bool)));
  QObject::connect(lcdTime->getTimer(), SIGNAL(paused(bool)),
                   statePanel, SLOT(setPause(bool)));
  QObject::connect(lcdTime->getTimer(), SIGNAL(modeSwitched(int)),
                   statePanel, SLOT(setMode(int)));
  QObject::connect(lcdTime->getTimer(), SIGNAL(modeSwitched(int)),
                   lcdDate, SLOT(setMode(int)));
  QObject::connect(lcdTime->getTimer(), SIGNAL(dateChanged(QDate&)),
                   lcdDate, SLOT(setDate(QDate&)));
  QObject::connect(lcdTime->getTimer(), SIGNAL(daysChanged(int)),
                   lcdDate, SLOT(setDays(int)));
}

// *** Methodes publiques *** //

KhronoTimeDisplay* KhronoDisplay::getTimeDisplay()
{
  return lcdTime;
}

// *** Slots publics *** //

void KhronoDisplay::lap()
{
  bool done=statePanel->addLap((const char*)(lcdTime->getTimer()->toString(DAYS_AND_TIME)));
  if( !done ) lcdTime->getTimer()->pause();
  emit lapped();
}

void KhronoDisplay::reset()
{
  statePanel->initLaps();
  lcdTime->getTimer()->reset();
}

void KhronoDisplay::setTheme(QColorGroup* colors)
{
  lcdTime->setPalette(QPalette(*colors, *colors, *colors));
  lcdDate->setPalette(QPalette(*colors, *colors, *colors));
  statePanel->setPalette(QPalette(*colors, *colors, *colors));
  emit themeChanged(colors);
}
