/*
     File: khronostatepanel.h
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KHRONO_STATE_PANEL_H
#define KHRONO_STATE_PANEL_H

#include <qwidget.h>
#include <qpainter.h>

#define MAXLAPS 3

class KhronoStatePanel : public QWidget
{
  Q_OBJECT
public:
  KhronoStatePanel( QWidget *parent=0, const char *name=0 );
  bool addLap(const char*);
  void initLaps();

public slots:
  void setStart(bool);
  void setPause(bool);
  void setMode(int);

protected:
  virtual void paintEvent( QPaintEvent* );

private:
  void paintMode( QPainter &p );
  void paintControls( QPainter &p );
  void paintLaps( QPainter &p );
  bool startState;
  bool pauseState;
  int modeState;
  char **lapTime;
  int laps;
};

#endif /* KHRONO_STATE_PANEL_H */
