/*
     File: khronotimer.h
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KHRONO_TIMER_H
#define KHRONO_TIMER_H

#include <qobject.h>
#include <qdatetime.h>
#include <qstring.h>

enum KhronoMode { TIME, CHRONO, COUNTDOWN };
enum TimeStringFormat { TIME_ONLY, DAYS_AND_TIME };

class KhronoTimer : public QObject
{
  Q_OBJECT
public:
  KhronoTimer( QObject * parent=0, const char * name=0 );
  QString toString();
  QString toString( int );
  void setCountdown( int d, int h, int m, int s );
  KhronoMode getMode();

signals:
  void modeSwitched( int );
  void started( bool );
  void paused(bool);
  void tick();
  void alarm();
  void dateChanged( QDate& );
  void daysChanged( int );

public slots:
  void switchMode();
  void startStop();
  void reset();
  void pause();

protected:
  virtual void timerEvent( QTimerEvent* );
  
private:
  void showTime();
  void showChrono();
  void showCountdown();
  //void show();
  KhronoMode mode;
  int timer;
  QDateTime *time;
  long seconds;
  int startDays, startHours, startMins, startSecs;
  bool start_;
  bool paused_;
};

class KhronoInterface : public QObject
{
  Q_OBJECT
protected slots:
  virtual void setStart(bool)=0;
  virtual void setPause(bool)=0;
  virtual void setMode(int)=0;
  virtual void lap()=0;
};

#endif /* KHRONO_TIMER_H */
