// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: kwatchmsg.cpp,v 1.1 2001/08/02 20:04:14 mj Exp $
 *
 * 
 *
 *****************************************************************************
 * Copyright (C) 2000-2001
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *
 * Based on kwatch 0.3, with the following copyright notice:
 *
 * Kwatch is Copyright (C) 1997,1998 Ralph C. Weichert and can be
 * distributed freely under the terms of the GNU General Public License
 * (see file COPYING)
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include <qlayout.h>
#include <qvbox.h>

#include <klocale.h>

#include "kwatchmsg.h"



/*
 * Constructor
 */
kwatchMsg::kwatchMsg(QWidget *parent)
    : KDialogBase(parent, "msg", false /*=modeless*/, i18n("KWatch Message"),
		  Ok, Ok)
{
    QWidget *page = new QWidget(this);
    setMainWidget(page);

    QVBoxLayout *v = new QVBoxLayout(page, 0, spacingHint());

    m_msg1 = new QLabel(page, "msg1");
    m_msg2 = new QLabel(page, "msg2");
    m_msg3 = new QLabel(page, "msg3");

    v->addWidget(m_msg1);
    v->addWidget(m_msg2);
    v->addWidget(m_msg3);

    // larger font for label msg2
    QFont f;
    f = m_msg2->font();
    f.setWeight(QFont::Bold);
    f.setPointSize(f.pointSize() * 3);
    m_msg2->setFont(f);
    
}


/*
 * Destructor
 */
kwatchMsg::~kwatchMsg()
{
}



/*
 * Set text labels
 */
void kwatchMsg::set1(const QString &s)
{
    m_msg1->setText(s);
}

void kwatchMsg::set2(const QString &s)
{
    m_msg2->setText(s);
}

void kwatchMsg::set3(const QString &s)
{
    m_msg3->setText(s);
}




#include "kwatchmsg.moc"
