// -*-Mode: C++;-*-
#ifndef CMainApp_included
#define CMainApp_included

#include <kmenubar.h>

#include <map>
#include <iostream>
#include <fstream>

#include "kmainwindow.h"
#include "sendmessage.h"

class CMainWindow;
class KPopupMenu;

class CMainApp : public KMainWindow,virtual public CSendMessage
{
    Q_OBJECT

public:
    CMainApp ( const char* name = NULL,bool _first = false );
    
    virtual ~CMainApp();
    virtual void append_message(const std::string&message);
    
protected:
    KPopupMenu*file;
    KPopupMenu*db_menu;
    KPopupMenu*server_menu;
    KPopupMenu*setup_menu;
    KPopupMenu*dialogs_menu;
    
    std::string logfile;
    std::ofstream filepointer;
    KMenuBar*MenuBar;
    CMainWindow* MainWidget;
    std::map<std::string,int> id_map;

    virtual void initToolbar();
    virtual void initMenu();
    
protected slots:
    void new_window();
    void raus_hier();
    void set_LogFileName();
    void connected_to_server(const char*);
    void disconnected_from_server();
    bool queryExit();
    bool queryClose();
    void layout_setup();

public slots:
    void windowClose();
signals:
};
#endif // CMainApp_included
