// -*-Mode: C++;-*- 
/**
 * The main widget (top-level-widget) of the application
 *
 * @see KTopLevelWidget
 */
#ifndef CMainWindow_included
#define CMainWindow_included

#include "MainWindowData.h"
#include <string>
#include "sendmessage.h"
#include "kmysqladmin/helpers/smart_pointer.h"

class CProgramOptions;
class CMySql;
class CTableView;
class CStatusView;
class CThreadView;
class CAccessrights;
class CSqlScript;

class CMainWindow : public CMainWindowData
{
    Q_OBJECT

public:
    CMainWindow (QWidget* parent = NULL, const char* name = NULL );
    virtual ~CMainWindow();
    void append_message(const std::string&text );
    void set_msg_ptr(CSendMessage*ptr);
    virtual bool close();
    bool connected();

private:
    CTableView*TableView;
    CStatusView*StatusView;
    CThreadView*ThreadView;
    CAccessrights*Grants;
    CSqlScript*sql_script;

protected slots:
    void connectSql();
    void browseTables();
    void createTable();
    void createDB();
    void dispStatus();
    void view_threads();
    void accessControl();
    virtual void alterTable();

public slots:
    void disconnectSql();
    void clearOutput();
    void reload_grants();
    void flush_cache();
    void close_tables();
    void new_log();
    void shutdown();
    void drop_table();
    void drop_db();
    void rename_table();
    void sql_Edit();
    void RestoreLastConnect();

signals:
    void connected(const char*);
    void disconnected();

protected:
    CSendMessage*msg_ptr;
    smart_pointer<CMySql> sql_server;
    void CloseAllDialogs();
    void _connect(const std::string&user,const std::string&host,
		  const std::string&port,const std::string&pass);
};
#endif // CMainWindow_included
