// -*-Mode: C++;-*-
/**
 * This class is designed to create an dialog with variables
 * counts of text-input fields.
 *
 * @short Textinputdialog
 * @see QWidget
 * @see QDialog
 */
#ifndef CMultiTextInput_included
#define CMultiTextInput_included

#include <qstrlist.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qmultilineedit.h>

#include "PatternPair.h"
#include "e_patternpair.h"
#include "MultiTextInputData.h"

class QFrame;

class CMultiTextInput : public CMultiTextInputData
{
    Q_OBJECT
public:
    CMultiTextInput(QWidget* parent = NULL,const char* name = NULL);
    virtual ~CMultiTextInput();
    void build_widgets(e_PatternList*which);
    PatternList*get_entries(bool emptys_too=FALSE);

protected:
    QList<QWidget>*EditList;
    QVBoxLayout * EditLayout;
    QVBoxLayout * ScrollLayout;
    QFrame*FrameWidget;
    void ResizeFrame();

    int min_x;
    int min_y;

protected slots:
    virtual void keyPressEvent(QKeyEvent*e);
    virtual void resizeEvent ( QResizeEvent * );
    virtual void change_focus();
};
#endif // CMultiTextInput_included
