// -*- Mode: C++; -*-
/***************************************************************************
                          accessrights.h  -  description
                             -------------------
    begin                : Die Sep 23 2003
    copyright            : (C) 2003 by Rajko Albrecht
    email                : ral@alwins-world.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ACCESSRIGHTS_H
#define _ACCESSRIGHTS_H

#include <qwidget.h>
#include <string>
#include "accessrightsdata.h"
#include "my_sql.h"

/**
  *@author Rajko Albrecht
  */
class CAccessrights : public CAccessrightsData
{
   Q_OBJECT                  

public: 
   CAccessrights(smart_pointer<CMySql>& _sql_server,QWidget *parent=0, const char *name=0, bool modal = FALSE, WFlags fl = 0);
    virtual ~CAccessrights();

protected:
    bool last_table_has_grant;
    smart_pointer<CMySql> sql_server;
    static const std::string User_Table;
    static const std::string DB_Table;
    static const std::string Host_Table;
    static const std::string DB_Name;
    static const std::string Tables_Table;
    static const std::string Tables_Name;
    static const std::string Tables_priv_col;
    static const std::string Column_priv_col;
    static const std::string Columns_Table;
    static const std::string Columns_Name;

    static const std::string cols_user_table;
    static const std::string cols_host_table;

public slots: // Public slots
    virtual void FontChanged();

protected slots:
    virtual void tabChanged(QWidget*);
    virtual void ReadHostTable();
    virtual void ReadUserTable();
    virtual void ReadDBTable();
    virtual void ReadTablesTable();
    virtual void ReadColumnTable();
    virtual void RefreshCurrent();
    virtual void RefreshLists();
    virtual void tablehilighted(QListViewItem*);
    virtual void userhilighted(QListViewItem*);
    virtual void hosthilighted(QListViewItem*);
    virtual void dbhilighted(QListViewItem*);
    virtual void columnhilighted(QListViewItem*);
    virtual void DeleteButton_clicked();
    virtual void AddButton_clicked();

public: // Public attributes

protected:
    virtual void delete_column_entry();
    virtual void delete_table_entry();
    virtual void delete_db_entry();
    virtual void delete_user_entry();
    virtual void delete_host_entry();
    virtual void add_host();
    virtual void add_user();
protected slots: // Protected slots
  /** No descriptions */
  virtual void EditButton_clicked();
  /** No descriptions */
  virtual void modify_host();
  virtual void modify_user(int type);
  virtual void showHelp();
};

#endif
