//-*-Mode: C++;-*-
/*
  converter.h  -  description                              
  -------------------                                         
  begin                : Sat Jul 3 1999                                           
  copyright            : (C) 1999 by Rajko Albrecht                         
  email                : Rajko.Albrecht@informatik.tu-chemnitz.de
*/

/*
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
                                                                           */


#ifndef CONVERTER_H
#define CONVERTER_H

#include "kmysqladmin/helpers/stringlist.h"
#include <string>
#include "kmysqladmin/helpers/smart_pointer.h"

/**
 *Base class for converting strings into other text for instance ASCII into HTML
 *
 *@author Rajko Albrecht
 */

class CConverter:virtual public ref_count {
public:
    /**
     * Types of converter known
     */
    enum ConvertTypes {HTML,LATEX};
    /** Constructor */
    CConverter();
    /**
     * creates a converter object
     * Returns an instance of a converter object. This is
     * the one and only way to get such object.
     *
     * @param type the type of converter to use
     * @return an instance of an converter or NULL if failure
     */
    static CConverter* get_converter(ConvertTypes type);
    virtual ~CConverter();
    const std::string&convert(const std::string&what);
    const std::string&get_original()const{return source;}
    const std::string&get_result()const{return dest;}
protected:
    std::string dest;
    std::string source;
    stringlist source_idents;
    stringlist target_idents;
    int count;
    virtual void avoid_new()=0;
};

#endif
