#include "selectoutfile.h"

#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>

#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "stringres.h"

#define Inherited CSelectOutFileData

CSelectOutFile::CSelectOutFile(QWidget* parent,const char* name)
    :Inherited( parent, name,true )
{
    setCaption( GET_TEXT(72));
    OkButton->setDefault(false);
    OkButton->setEnabled(false);
    FileNameEdit->setFocus();
    CurrentSel = 0;
    SelTypeGroup->setTitle(GET_TEXT(73) );
    SelAsciiButton->setText(GET_TEXT(75) );
    CancelButton->setText(GET_TEXT(108) );
}

CSelectOutFile::~CSelectOutFile()
{
}

void CSelectOutFile::SearchFile()
{
    QString s;
    QString pat;
    switch (CurrentSel) {
    case 0:
        pat = "*.txt";
        break;
    case 2:
        pat = "*.html";
        break;
    case 3:
        pat = "*.tex";
        break;
    case 1:
        pat = "*.csv";
        break;
    default:
        pat = "*";
        break;
    }
    s = KFileDialog::getSaveFileName(0,pat);
    FileNameEdit->setText(s);
}

void CSelectOutFile::SelectionChanged(int i)
{
    CurrentSel = i;
}

void CSelectOutFile::textchange(const QString&text)
{
    if (text.length() > 0) {
        OkButton->setDefault(true);
        OkButton->setEnabled(true);
    } else {
        OkButton->setDefault(false);
        OkButton->setEnabled(false);
    }
    currentName = text;
}
