#include <qpainter.h>
#include <previewfield.h>
#include <stdio.h>

Previewfield::Previewfield(QWidget *parent,Playfield *p):QWidget(parent){
  playfield=p;
  updateJewel();
}

void Previewfield::paintEvent(QPaintEvent *pe)
{
  QPainter p;
  QBrush br;
  int i,c;

  //printf("Repainting Preview\n");
  p.begin(this);
  p.setPen(NoPen);
  br.setStyle(SolidPattern);
  for(i=0;i<3;i++){
    c=nextJewel[i];
    if(c<100)
      p.drawPixmap(2,32*2-i*32+2
		   ,*(playfield->nextJewel->jewelPixmaps[c==10?8:c]));
    else
      p.drawPixmap(2,32*2-i*32+2,*(playfield->nextJewel->jewelPixmaps[0]));
  };
  p.end();
}

void Previewfield::updateJewel()
{  
  int *ptr;
  int i;

  nextJewel=new(int[4]);
  ptr=playfield->getNextJewel();
  for(i=0;i<3;i++)nextJewel[i]=ptr[i];
  repaint();
}
