/***************************************************************************
                           dmcdata.h  -  Part of KST
                             -------------------
    begin                : Wed July 4 2007
    copyright            : (C) 2007 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KST_DMC_H
#define _KST_DMC_H

#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>

#include <config.h>

#include <kstsharedptr.h>

extern "C" {
#include <HL2_DMC/PIODB.h>
}

struct DMCRange {
  PIOLONG firstIndex;
  PIOLONG lastIndex;
};

namespace DMC {
    extern bool haveDMC();
    extern bool validDatabase(const QString&);

class Source : public KstShared {
  public:
    Source();
    virtual ~Source();

    virtual bool isValid() const;
    virtual bool updated() const;
    virtual bool setGroup(const QString& group);
    virtual QStringList fields() const;
    virtual void reset();
    virtual PIOLONG readObject(const QString& object, double *buf, PIOLONG start, PIOLONG end);
    virtual DMCRange range(const QString& object) const;

  protected:
    bool _isValid;
    QString _group;
};

}

#endif

