/***************************************************************************
                    dirfilesavedialog_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2010 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfiledialog.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qtable.h>

#include <kcombobox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <ktempfile.h>
#include <kio/netaccess.h>
#include <kstandarddirs.h>

extern "C" {
#include <getdata.h>
}

#include "dirfilesave_i.h"
#include "kstdatacollection.h"
#include "kstvector.h"

DirfileSaveI::DirfileSaveI(QWidget* parent, const char* name, bool modal, WFlags fl)
: DirfileSave(parent, name, modal, fl) {
  connect(_closeButton, SIGNAL(clicked()), this, SLOT(hide()));
  connect(_saveButton, SIGNAL(clicked()), this, SLOT(save()));
  connect(_vectorList, SIGNAL(selectionChanged()), this, SLOT(selectionChanged()));
  connect(_vectorList, SIGNAL(doubleClicked(QListBoxItem*)), this, SLOT(save()));

  init();
}


DirfileSaveI::~DirfileSaveI() {
}


void DirfileSaveI::init() {
  KstVectorList::ConstIterator i;

  _vectorList->clear();

  KST::vectorList.lock().readLock();
  for (i = KST::vectorList.begin(); i != KST::vectorList.end(); ++i) {
    (*i)->readLock();
    _vectorList->insertItem((*i)->tag().displayString());
    (*i)->unlock();
  }
  KST::vectorList.lock().unlock();

  _saveButton->setEnabled(false);
}


void DirfileSaveI::saveVectors(const QString& name, KstVectorList& toSave, int length, QString& strError, bool& haveError) {
  KstVectorList::Iterator it;
  KstVectorPtr v;
  DIRFILE *file;
  int error = GD_E_OK;

  file = dirfile_open(name.latin1(), GD_RDWR | GD_CREAT | GD_TRUNC );
  if (file) {
    for (it = toSave.begin(); it != toSave.end(); it++) {
      QString nameVector;

      v = *it;

      if( v ) {
        nameVector = v->tag().tagString();

        //
        // make sure we don't try to use a reserved character...
        //

        nameVector.replace("/", "_");
        nameVector.replace("|", "_");
        nameVector.replace("&", "_");
        nameVector.replace("<", "_");
        nameVector.replace(">", "_");
        nameVector.replace(".", "_");
        nameVector.replace(";", "_");

        if( nameVector.compare("INDEX") != 0 ) {
          if( dirfile_add_raw(file, nameVector.latin1(), GD_FLOAT64, 1, 0) == 0 ) {
            if( v->length() < length ) {
              //
              // need to interpolate the vector up...
              //

              double* values;
              int i;

              values = new double[length];
              for( i=0; i<length; i++) {
                values[i] = v->interpolate(i, length);
              }

              if( putdata(file, nameVector.latin1(), 0, 0, 0, length, GD_FLOAT64, values) == 0 ) {
                error = get_error(file);
              }

              delete[] values;
          } else {
              if( putdata(file, nameVector.latin1(), 0, 0, 0, length, GD_FLOAT64, v->value()) == 0 ) {
                error = get_error(file);
              }
            }
          } else {
            error = get_error(file);
          }
        }

        if( error != GD_E_OK ) {
          char errorBuffer[1024];

          get_error_string(file, errorBuffer, 1024);

          strError += i18n("%1: %2\n").arg(v->tag().tagString().latin1()).arg(errorBuffer);

          haveError = true;
        }
      }
    }

    dirfile_close(file);
  }
}

void DirfileSaveI::save() {
  KstVectorList::Iterator it;
  KstVectorList toSave;
  KstVectorPtr v;
  QListBoxItem *i;
  QString name;
  QString namePlus;
  QString strError = i18n("There were errors in saving the following vector(s):\n");
  bool haveError = false;
  int length = 0;
  int n = 1;

  KST::vectorList.lock().readLock();
  for (i = _vectorList->firstItem(); i; i = i->next()) {
    if (i->isSelected()) {
      v = *KST::vectorList.findTag(i->text());
      if (v) {
        toSave += v;

        v->readLock();
      }
    }
  }
  KST::vectorList.lock().unlock();

  name = QFileDialog::getSaveFileName( QString::null, "", this, "SaveDirfile", "Save Vector(s) As" );
  if (!name.isEmpty()) {
    switch (_multiOptions->currentItem()) {
      case 0: // truncate long vectors
        for (it = toSave.begin(); it != toSave.end(); it++) {
          v = *it;

          if (it == toSave.begin() || v->length() < length) {
            length = v->length();
          }
        }
        saveVectors(name, toSave, length, strError, haveError);
        break;

      case 1: // interpolate short vectors
        for (it = toSave.begin(); it != toSave.end(); it++) {
          v = *it;

          if (it == toSave.begin() || v->length() > length) {
            length = v->length();
          }
        }
        saveVectors(name, toSave, length, strError, haveError);
        break;

      case 2: // save in separate files
        for (it = toSave.begin(); it != toSave.end(); it++) {
          KstVectorList toSaveActual;

          v = *it;
          toSaveActual += v;

          namePlus = QString("%1.%2").arg(name).arg(n);

          saveVectors(namePlus, toSaveActual, v->length(), strError, haveError);
          ++n;
        }
        break;
    }

    for (it = toSave.begin(); it != toSave.end(); it++) {
      (*it)->unlock();
    }

    if (haveError) {
      KMessageBox::sorry(this, strError, i18n("Kst"));
    }
  }
}


void DirfileSaveI::show() {
  init();
  QDialog::show();
}


void DirfileSaveI::selectionChanged() {
  QListBoxItem *i;
  int cnt = 0;

  for (i = _vectorList->firstItem(); i; i = i->next()) {
    if (i->isSelected()) {
      ++ cnt;

      if (cnt > 1) {
        break;
      }
    }
  }

  _multiOptions->setEnabled(cnt > 1);
  _saveButton->setEnabled(cnt > 0);
}

#include "dirfilesave_i.moc"
