/***************************************************************************
                              bind_dir.cpp
                             -------------------
    begin                : Mar 2 2009
    copyright            : (C) 2009 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "bind_dir.h"

#include <qdir.h>

#include <kdebug.h>

KstBindDir::KstBindDir(KJS::ExecState *exec, QDir *d)
: KstBinding("Dir"), _d(d) {
  KJS::Object o(this);
  addBindings(exec, o);
}


KstBindDir::KstBindDir(KJS::ExecState *exec, KJS::Object *globalObject)
: KstBinding("Dir") {
  KJS::Object o(this);
  addBindings(exec, o);
  if (globalObject) {
    globalObject->put(exec, "Dir", o);
  } else {
    _d = new QDir;
  }
}


KstBindDir::KstBindDir(int id)
: KstBinding("Dir Method", id) {
}


KstBindDir::~KstBindDir() {
}


KJS::Object KstBindDir::construct(KJS::ExecState *exec, const KJS::List& args) {
  QString name;
  if (args.size() != 1) {
    return createSyntaxError(exec);
  }

  if (args.size() == 1) {
    if (args[0].type() != KJS::StringType) {
      return createTypeError(exec, 0);
    }
    name = args[0].toString(exec).qstring();
  }

  QDir *d = new QDir(name);

  return KJS::Object(new KstBindDir(exec, d));
}


struct DirBindings {
  const char *name;
  KJS::Value (KstBindDir::*method)(KJS::ExecState*, const KJS::List&);
};


struct DirProperties {
  const char *name;
  void (KstBindDir::*set)(KJS::ExecState*, const KJS::Value&);
  KJS::Value (KstBindDir::*get)(KJS::ExecState*) const;
};


static DirBindings dirBindings[] = {
  { "fileList", &KstBindDir::fileList },
  { "dirList", &KstBindDir::dirList },
  { 0L, 0L }
};


static DirProperties dirProperties[] = {
  { "path", &KstBindDir::setPath, &KstBindDir::path },
  { 0L, 0L, 0L }
};


KJS::ReferenceList KstBindDir::propList(KJS::ExecState *exec, bool recursive) {
  KJS::ReferenceList rc = KstBinding::propList(exec, recursive);

  for (int i = 0; dirProperties[i].name; ++i) {
    rc.append(KJS::Reference(this, KJS::Identifier(dirProperties[i].name)));
  }

  return rc;
}


bool KstBindDir::hasProperty(KJS::ExecState *exec, const KJS::Identifier& propertyName) const {
  QString prop = propertyName.qstring();

  for (int i = 0; dirProperties[i].name; ++i) {
    if (prop == dirProperties[i].name) {
      return true;
    }
  }

  return KstBinding::hasProperty(exec, propertyName);
}


void KstBindDir::put(KJS::ExecState *exec, const KJS::Identifier& propertyName, const KJS::Value& value, int attr) {
  if (!_d) {
    KstBinding::put(exec, propertyName, value, attr);
    return;
  }

  QString prop = propertyName.qstring();

  for (int i = 0;dirProperties[i].name; ++i) {
    if (prop == dirProperties[i].name) {
      if (!dirProperties[i].set) {
        break;
      }
      (this->*dirProperties[i].set)(exec, value);
      return;
    }
  }

  KstBinding::put(exec, propertyName, value, attr);
}


KJS::Value KstBindDir::get(KJS::ExecState *exec, const KJS::Identifier& propertyName) const {
  if (!_d) {
    return KstBinding::get(exec, propertyName);
  }

  QString prop = propertyName.qstring();

  for (int i = 0; dirProperties[i].name; ++i) {
    if (prop == dirProperties[i].name) {
      if (!dirProperties[i].get) {
        break;
      }
      return (this->*dirProperties[i].get)(exec);
    }
  }

  return KstBinding::get(exec, propertyName);
}


KJS::Value KstBindDir::call(KJS::ExecState *exec, KJS::Object& self, const KJS::List& args) {
  int id = this->id();

  if (id <= 0) {
    return createInternalError(exec);
  }

  KstBindDir *imp = dynamic_cast<KstBindDir*>(self.imp());
  if (!imp) {
    return createInternalError(exec);
  }

  return (imp->*dirBindings[id - 1].method)(exec, args);
}


void KstBindDir::addBindings(KJS::ExecState *exec, KJS::Object& obj) {
  for (int i = 0; dirBindings[i].name != 0L; ++i) {
    KJS::Object o = KJS::Object(new KstBindDir(i + 1));
    obj.put(exec, dirBindings[i].name, o, KJS::Function);
  }
}


KJS::Value KstBindDir::fileList(KJS::ExecState *exec, const KJS::List& args) {
  KJS::List rc;

  if (!_d) {
    return createInternalError(exec);
  }

  if (args.size() != 1) {
    return createSyntaxError(exec);
  }

  if (args[0].type() != KJS::StringType) {
    return createTypeError(exec, 0);
  }

  QStringList l = _d->entryList( args[0].toString(exec).qstring(), QDir::Files );

  for (QStringList::ConstIterator i = l.begin(); i != l.end(); ++i) {
    rc.append(KJS::String(*i));
  }

  return KJS::Object(exec->interpreter()->builtinArray().construct(exec, rc));
}


KJS::Value KstBindDir::dirList(KJS::ExecState *exec, const KJS::List& args) {
  KJS::List rc;

  if (!_d) {
    return createInternalError(exec);
  }

  if (args.size() != 1) {
    return createSyntaxError(exec);
  }

  if (args[0].type() != KJS::StringType) {
    return createTypeError(exec, 0);
  }

  QStringList l = _d->entryList( args[0].toString(exec).qstring(), QDir::Dirs );

  for (QStringList::ConstIterator i = l.begin(); i != l.end(); ++i) {
    rc.append(KJS::String(*i));
  }

  return KJS::Object(exec->interpreter()->builtinArray().construct(exec, rc));
}


void KstBindDir::setPath(KJS::ExecState *exec, const KJS::Value& value) {
  if (!_d) {
    createInternalError(exec);
  }

  if (value.type() != KJS::StringType) {
    createPropertyTypeError(exec);
  }

  _d->setPath(value.toString(exec).qstring());
}

KJS::Value KstBindDir::path(KJS::ExecState *exec) const {
  if (!_d) {
    return createInternalError(exec);
  }

  return KJS::String(_d->path());
}

