/***************************************************************************
                    kstmatrixsavedialog_i.cpp  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2010 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlistbox.h>
#include <qpushbutton.h>

#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <ktempfile.h>
#include <kio/netaccess.h>
#include <kstandarddirs.h>

#include "kstmatrixsavedialog_i.h"
#include "vectorselector.h"

KstMatrixSaveDialogI::KstMatrixSaveDialogI(QWidget* parent,
                                             const char* name,
                                             bool modal,
                                             WFlags fl)
: MatrixSaveDialog(parent, name, modal, fl) {
  connect(pushButton2, SIGNAL(clicked()), this, SLOT(hide()));
  connect(_saveButton, SIGNAL(clicked()), this, SLOT(save()));
  connect(_matrixList, SIGNAL(selectionChanged()), this, SLOT(selectionChanged()));
  connect(_matrixList, SIGNAL(doubleClicked(QListBoxItem*)), this, SLOT(save()));

  init();
}


KstMatrixSaveDialogI::~KstMatrixSaveDialogI() {
}


void KstMatrixSaveDialogI::init() {
  _matrixList->clear();
  KST::matrixList.lock().readLock();
  for (KstMatrixList::ConstIterator i = KST::matrixList.begin(); i != KST::matrixList.end(); ++i) {
    (*i)->readLock();
    _matrixList->insertItem((*i)->tag().displayString());
    (*i)->unlock();
  }
  KST::matrixList.lock().unlock();
  _saveButton->setEnabled(false);
}


void KstMatrixSaveDialogI::save() {
  KstMatrixPtr m;

  KST::matrixList.lock().readLock();
  for (QListBoxItem *i = _matrixList->firstItem(); i; i = i->next()) {
    if (i->isSelected()) {
      m = *KST::matrixList.findTag(i->text());
      if (m) {
        break;
      }
    }
  }
  KST::matrixList.lock().unlock();

  KURL url = KFileDialog::getSaveURL(QString::null, QString::null, this, i18n("Save Matrix As"));
  if (m && !url.isEmpty()) {
    KTempFile tf(locateLocal("tmp", "kstvectors"), "txt");

    tf.setAutoDelete(true);
    if (0 != KstData::self()->matrixToFile(m, tf.file())) {
      KMessageBox::sorry(this, i18n("Error saving matrix to %1.").arg(url.prettyURL()), i18n("Kst"));

      return;
    }
#if KDE_VERSION >= KDE_MAKE_VERSION(3,3,0)
    tf.sync();
#else
    tf.close();
#endif

#if KDE_VERSION >= KDE_MAKE_VERSION(3,3,0)
    if (KIO::NetAccess::exists(url, false, this)) {
#else
    if (KIO::NetAccess::exists(url)) {
#endif
      int rc = KMessageBox::warningYesNo(this, i18n("File %1 exists.  Overwrite?").arg(url.prettyURL()), i18n("Kst"));
      if (rc == KMessageBox::No) {
        return;
      }
    }
#if KDE_VERSION >= KDE_MAKE_VERSION(3,2,0)
    KIO::NetAccess::file_copy(KURL(tf.name()), url, -1, true, false, this);
#else
    KIO::NetAccess::upload(tf.name(), url);
#endif
  }
}


void KstMatrixSaveDialogI::show() {
  init();
  QDialog::show();
}


void KstMatrixSaveDialogI::selectionChanged() {
  int cnt = 0;
  // expensive but qlistbox provides nothing better at the moment
  for (QListBoxItem *i = _matrixList->firstItem(); i; i = i->next()) {
    if (i->isSelected()) {
      if (++cnt > 1) {
        break;
      }
    }
  }
  _saveButton->setEnabled(cnt > 0);
}

#include "kstmatrixsavedialog_i.moc"

