/***************************************************************************
                          editdlg.cpp  -  description
                             -------------------
    begin                : Tue Jul 24 2001
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <klocale.h>
#include <kapp.h>
#if KDE_VERSION_MAJOR > 2
#include <qtextedit.h>
#else
#include <qmultilineedit.h>
#endif
#include "editdlg.h"

#if KDE_VERSION_MAJOR > 2
EditDlg::EditDlg(QWidget* _parent, QString* _s, int ts) :
#else
EditDlg::EditDlg(QWidget* _parent, QString* _s) :
#endif
 KDialogBase(Plain, i18n("Edit"), Ok | Apply | Cancel, Ok, _parent, 0,
             true, true), s(_s)
{
  resize(260, 260);
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
#if KDE_VERSION_MAJOR > 2
  vbox->addWidget(edit = new QTextEdit(frame));
  edit->setTextFormat(Qt::PlainText);
  if (ts)
    edit->setTabStopWidth(ts * edit->fontMetrics().width(QChar('0')));
#else
  vbox->addWidget(edit = new QMultiLineEdit(frame));
#endif
  edit->setText(*s);
}

EditDlg::~EditDlg()
{
}

void EditDlg::slotOk()
{
  *s = edit->text();
  accept();
}

void EditDlg::slotApply()
{
  *s = edit->text();
  emit applyClicked();
}
