#!/usr/bin/python
##################################################################
#                                                                #
#       demo2.py                                                 #
#                                                                #
#       This file is a part of kpl - a program for graphical     #
#       presentation of data sets and functions.                 #
#                                                                #
#       Copyright (C) 2004 by Werner Stille                      #
#       <stille@uni-freiburg.de>                                 #
#                                                                #
#       Released under the GPL; see file LICENSE for details.    #
#                                                                #
##################################################################
#
# Example script for Kpl.
#
# To run it, you need to install the kdebindings including dcoppython
#

import os
from time import sleep
import pcop

try:
  import pydcop
  server = pydcop.anyAppCalled("kpl");
except:
  import dcop
  server = dcop.anyAppCalled("kpl");

prefix = os.environ['KDEDIR']
if prefix:
  prefix += "/share/apps/kpl/"
else:
  prefix = "/opt/kde3/share/apps/kpl/"

print "Autoplot settings"
server.KplIface.setAutoplot(4.0, 15.0, 3.0, 10.0, 2, "x", "y", "",
                            1, 0, 1, 2, 0, 0, 0, 1, 1, 0)
print "Setting Autoplot on"
server.KplIface.setAutoplotOption(1)
print "Open data file...",
if server.KplIface.openData(prefix + "demo1.dat"):
  print "true"
else:
  print "false"
sleep(3)
print "Open plot file...",
if server.KplIface.openPlot(prefix + "demo5.plo"):
  print "true"
else:
  print "false"
print "Deleting items...",
sleep(2)
if server.KplIface.deleteItem(8):
  print "true",
else:
  print "false",
if server.KplIface.deleteItem(4):
  print "true",
else:
  print "false",
if server.KplIface.deleteItem(6):
  print "true",
else:
  print "false",
if server.KplIface.deleteItem(3):
  print "true",
else:
  print "false",
if server.KplIface.deleteItem(4):
  print "true",
else:
  print "false",
if server.KplIface.deleteItem(2):
  print "true"
else:
  print "false"
sleep(3)
print "New plot";
server.KplIface.newPlot()
print "New frame item"
server.KplIface.newFrameItem(4.0, 15.0, 3.0, 10.0, 0.0, 12.5664,
                             -2.0, 2.0, 0, 0, 2, -1, "0", "0", 3.14159, 1.0,
                             2, 2, 2, 0, 0, "x", "y", "Fourier synthesis",
                             1.0, 1)
print "Setting Autoplot off"
server.KplIface.setAutoplotOption(0)
print "New function item"
server.KplIface.newFunItem(prefix + "fkt.so", "foursynth", 0.0, 12.566,
                           0.01, 1, "ff", 1.0, 1.0, 1);
print "Setting parameter...",
if server.KplIface.setPar(1, 3, 0.0, 1):
  print "true"
else:
  print "false"
print "Performing plot"
server.KplIface.doPlot()
sleep(1)
print "Setting Autoplot on"
server.KplIface.setAutoplotOption(1)
print "Changing parameters...",
for i in range(11):
  if server.KplIface.setPar(1, 3, i * 0.1, 1):
    print "true",
  else:
    print "false",
sleep(2)
if server.KplIface.setPar(1, 7, -0.11111111, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(1, 11, 0.04, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(1, 15, -0.0204082, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(1, 19, 0.01234567, 1):
  print "true"
else:
  print "false"
sleep(3)
print "New plot"
server.KplIface.newPlot()
print "New frame item"
server.KplIface.newFrameItem(4.0, 10.0, 3.0, 10.0, -1.0, 1.0,
                             -1.0, 1.0, 0, 0, 1, 1, "0", "0", 0.5, 0.5,
                             5, 5, 2, 0, 0, "x", "y",
                             "Parametric function", 1.5, 1)
print "New parametric function item"
server.KplIface.newParFunItem(prefix + "fkt.so", "foursynth",
                              prefix + "fkt.so", "foursynth", 0.0, 6.28318,
                              0.0, 1, "ff", 1.0, 1.0, 1)
print "Setting Autoplot off"
server.KplIface.setAutoplotOption(0)
for i in range(10):
  print "Changing parameters...",
  if server.KplIface.setPar(1, 2, i * 0.1, 1):
    print "true",
  else:
    print "false",
  if server.KplIface.setPar(1, 7, i * 0.1, 0):
    print "true",
  else:
    print "false",
  print "\nPerforming plot"
  server.KplIface.doPlot()
sleep(3)
print "New plot"
server.KplIface.newPlot()
print "New autoframe item"
server.KplIface.newAutoFrameItem()
print "New array item"
server.KplIface.newArrayItem(prefix + "demo7.dat",
                             0, 1, 2, 0, 51, 1, 0, "0", 1.0, 1.0, 1)
print "New array item"
server.KplIface.newArrayItem(prefix + "demo7.dat",
                             0, 3, 4, 0, 51, 1, 0, "0", 1.0, 1.0, 1)
print "Autoscaling...",
if server.KplIface.autoScaleFrame(0, 1):
  print "true"
else:
  print "false"
print "New function item"
server.KplIface.newFunItem(prefix + "fcompl.so", "epsilon_1", 2.0, 7.0,
                           0.0, 1, "0", 1.0, 1.0, 1);
print "Changing parameters...",
if server.KplIface.setPar(3, 0, 3.5, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(3, 1, 8.5, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(3, 2, 7500.0, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(3, 3, 1.0, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(3, 4, 150000.0, 1):
  print "true"
else:
  print "false"
print "New function item"
server.KplIface.newFunItem(prefix + "fcompl.so", "epsilon_2", 2.0, 7.0,
                           0.0, 1, "ff", 1.0, 1.0, 1);
print "Changing parameters...",
if server.KplIface.setPar(4, 0, 3.5, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(4, 1, 8.5, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(4, 2, 7500.0, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(4, 3, 1.0, 1):
  print "true",
else:
  print "false",
if server.KplIface.setPar(4, 4, 150000.0, 1):
  print "true"
else:
  print "false"
print "Performing plot"
server.KplIface.doPlot()
print "Setting Autoplot on"
server.KplIface.setAutoplotOption(1)
print "Enabling fit parameters...",
for i in range(20):
  if i < 5:
    b = 1
  else:
    b = 0
  if server.KplIface.enableFitPar(i, b):
    print "true",
  else:
    print "false",
print "\nAdding fit items...",
if server.KplIface.addFitItems(1, 1, 3, 1, "", ""):
  print "true",
else:
  print "false",
if server.KplIface.addFitItems(0, 2, 4, 1, "", ""):
  print "true"
else:
  print "false"
sleep(3)
print "Performing fit...",
if  server.KplIface.fit(1, 0, 0):
  print "true"
else:
  print "false"
print "chi-square =",
print server.KplIface.chiSquare()
sleep(3)
print "New plot"
server.KplIface.newPlot()
print "New legend item"
server.KplIface.newLegendItem(-17, "0", 3.2, 7.5, "#BNThe End",
                              "cc6600", 0.0, 0.0, 5.0, 1)
