/***************************************************************************
                          brushdlg.cpp  -  description
                             -------------------
    begin                : Mit Mai 14 2003
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qapplication.h>
#include <qbuttongroup.h>
#include <qdrawutil.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qradiobutton.h>
#include <qstyle.h>
#include <kapp.h>
#include <klocale.h>
#include "brushdlg.h"
#include "kgraph.h"

BrushButton::BrushButton(QWidget* _parent, int br) :
 QPushButton(_parent), brush(br)
{
  connect(this, SIGNAL(clicked()), SLOT(slotBrush()));
}

BrushButton::~BrushButton()
{
}

int BrushButton::value()
{
  return brush;
}

void BrushButton::slotBrush()
{
  BrushDlg dlg(parentWidget(), &brush);
  dlg.exec();
  repaint();
}

void BrushButton::drawButtonLabel(QPainter* p)
{
#if KDE_VERSION_MAJOR < 3
  QRect r = QApplication::style().buttonRect(0, 0, width(), height());
#else
  QRect r = style().subRect(QStyle::SR_PushButtonContents, this);
#endif
  int l = r.x() + 4;
  int t = r.y() + 4;
  int w = r.width() - 8;
  int h = r.height() - 8;
  if (brush)
    p->fillRect(l, t, w, h, (BrushStyle) KGraph::pattern[brush]);
  else
    p->drawRect(l, t, w, h);
}

BrushRadioButton::BrushRadioButton(QWidget* _parent, int br) :
 QRadioButton(_parent), brush(br)
{
}

BrushRadioButton::~BrushRadioButton()
{
}

void BrushRadioButton::drawButtonLabel(QPainter* p)
{
#if KDE_VERSION_MAJOR < 3
  QRect r = QApplication::style().buttonRect(0, 0, width(), height());
  r.setX(r.x() + QApplication::style().exclusiveIndicatorSize().width() + 6);
#else
  QRect r = style().subRect(QStyle::SR_RadioButtonContents, this);
#endif
  if (brush)
    p->fillRect(r, (BrushStyle) KGraph::pattern[brush]);
  else
    p->drawRect(r);
}

BrushDlg::BrushDlg(QWidget* _parent, int* br) :
 KDialogBase(Plain, i18n("Patterns"),
 Ok | Cancel, Ok, _parent), brush(br)
{
  QFrame* frame = plainPage();
  (new QVBoxLayout(frame, 0, spacingHint()))->
    addWidget(bg = new QButtonGroup(4, Qt::Vertical, QString(""), frame));
  for (int i = 0; i < 8; i++) {
    BrushRadioButton* r = new BrushRadioButton(bg, i);
    if (*br == i)
      r->setChecked(true);
  }
}

BrushDlg::~BrushDlg()
{
}

void BrushDlg::slotOk()
{
  *brush = bg->id(bg->selected());
  accept();
}
