/***************************************************************************
                          choosefuncdlg.cpp  -  description
                             -------------------
    begin                : Mit Jul 23 2003
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfile.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qregexp.h>
#include <qtextstream.h>
#include <kapp.h>
#include <klocale.h>
#include "choosefuncdlg.h"

ChooseFuncDlg::ChooseFuncDlg(QWidget* _parent, QFile* f, QLineEdit* func0,
                             bool d3) :
 KDialogBase(Plain, QString::null, Ok | Cancel, Ok, _parent), func(func0)
{
  setPlainCaption(i18n("Functions"));
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  vbox->addWidget(funcList = new QListBox(frame));
#if KDE_VERSION_MAJOR > 2
  QRegExp rx2("\\S+__");
  QRegExp rx2a(d3 ? "\\S+__FddPCd" : "\\S+__FdPCd");
  QRegExp rx3("_\\S+");
  QRegExp rx3a(d3 ? "_Z\\d+\\S+ddPKd" : "_Z\\d+\\S+dPKd");
#else
  QRegExp rx2("[^\\s]+__");
  QRegExp rx2a(d3 ? "[^\\s]+__FddPCd" : "[^\\s]+__FdPCd");
  QRegExp rx3("_[^\\s]+");
  QRegExp rx3a(d3 ? "_Z\\d+[^\\s]+ddPKd" : "_Z\\d+[^\\s]+dPKd");
#endif
  QTextStream t(f);
  while (!t.eof()) {
    QString line = t.readLine();
    if (line[9] == 'T') {
      QString s = line.mid(11);
#if KDE_VERSION_MAJOR > 2
      if ((rx2.search(s) && rx3.search(s)) || (!rx2a.search(s)) ||
          (!rx3a.search(s)))
#else
      if ((rx2.find(s, 0) && rx3.find(s, 0)) || (!rx2a.find(s, 0)) ||
          (!rx3a.find(s, 0)))
#endif
        funcList->insertItem(s);
    }
  }
  f->close();
  connect(funcList, SIGNAL(selected(int)), SLOT(slotList(int)));
  resize(200, 200);
}

ChooseFuncDlg::~ChooseFuncDlg()
{
}

void ChooseFuncDlg::slotList(int i)
{
  func->setText(funcList->text(i));
  accept();
}

void ChooseFuncDlg::slotOk()
{
  int i = funcList->currentItem();
  if (i != -1) {
    func->setText(funcList->text(i));
    accept();
  }
}
