/* -*- c++ -*-
*
* corelauncher.h
*
* Copyright (C) 2004 Petter Stokke <ummo@hellokitty.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
*
*/

#ifndef __kmldonkey_kded_kmldonkey_corelauncher_h__
#define __kmldonkey_kded_kmldonkey_corelauncher_h__

#include <kprocio.h>
#include <qdict.h>
#include <qstringlist.h>

class HostManager;
class HostInterface;
class DCOPClient;

class CoreProcess : public KProcIO
{
    Q_OBJECT
public:
    CoreProcess();
    
    const QString& id() const;
    QString output() const;
    bool isDying() const;
    void startCore(HostInterface* i);
    void killCore();

private slots:
    void outputReady(KProcIO* core);

private:
    QString m_id;
    QStringList m_output;
    bool m_dying;
};

class CoreLauncher : public QObject
{
    Q_OBJECT
public:
    CoreLauncher(QObject* parent = 0, const char* name = 0);
    ~CoreLauncher();
    
    bool isCoreRunning(const QString& id) const;
    bool isValidCore(const QString& id) const;
    QStringList coreNames() const;

public slots:
    void startCore(const QString& id);
    void startCore(HostInterface* i);
    void stopCore(const QString& id);
    void stopCore(HostInterface* i);

private slots:
    void applicationRegistered(const QCString& appId);
    void applicationRemoved(const QCString& appId);
    void hostListUpdated();
    void processExited(KProcess* core);

    /** Launch any cores matching the filter not already running.
     * @param filter A value from HostInterface::StartupMode, or -1 to match all cores.
     */
    void launchCores(int filter);
    /** Shut down any running cores matching the filter.
     * If the filter is -1, also detaches the core child processes. This should only be used from the destructor.
     * @param filter A value from HostInterface::StartupMode, or -1 to match all cores, or -2 to match unknown cores.
     */
    void shutdownCores(int filter);

private:
    HostManager* m_hosts;
    DCOPClient* m_dcop;
    QDict<CoreProcess> m_cores;
    bool m_kmldonkeyRunning;
};

#endif
