/***************************************************************************
 *
 * knetworkmanager.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_TRAY_H
#define KNETWORKMANAGER_TRAY_H

#include <qmap.h>
#include <qtimer.h>

#include <qtooltip.h>
#include <ksystemtray.h>
#include <kuniqueapplication.h>
#include <kpopupmenu.h>
#include <kactionclasses.h>
#include <kstdaction.h>
#include <kstdguiitem.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qprogressbar.h>
#include <qguardedptr.h>

// class QMouseEvent;
class KPopupMenu;
class KNetworkManager;
class Device;
class VPNConnection;
class DialUp;
class Network;
class DeviceStore;

#include "knetworkmanager.h"
#include "knetworkmanager-notify.h"
#include "knetworkmanager-devicestore.h"
#include "knetworkmanager-vpn.h"
#include "knetworkmanager-state.h"

#define NUM_CONNECTING_STAGES 3
#define NUM_CONNECTING_FRAMES 11

class WirelessNetworkItem : public QCustomMenuItem
{
	public:
	  WirelessNetworkItem  (QWidget*, const QString & essid, bool active, int strength, bool encrypted, bool adhoc);
	  ~WirelessNetworkItem ();

	  QWidget*      parent;
	  QProgressBar* pbarStrength;

	  void  paint    (QPainter*, const QColorGroup&, bool, bool, int, int, int, int);
	  QSize sizeHint ();

	private:
	  QString _essid;
	  int     _strength;
	  bool    _encrypted;
	  bool    _adhoc;

	  /* menu item */
	  int _width;
	  int _height;
	  int _border;

	  /* elements */
	  int _textHeight;
	  int _widgetHeight;

	  int _space;
};


class Subhead : public QWidget
{
	public:
	  Subhead  (QWidget*, const char *, const QString &, const QPixmap);
	  ~Subhead ();
};

class Tray : public KSystemTray
{
	Q_OBJECT

	public:
	  Tray ();
	  ~Tray ();

	  KAction* connectHiddenAction;
	  KAction* configureVPNAction;
	  KAction* disconnectVPNAction;
	  KAction* configureDialUpAction;
	  KAction* switchOnAction;
	  KAction* switchOffAction;
	  KAction* switchWirelessOnAction;
	  KAction* switchWirelessOffAction;
	  KAction* showNetworksDialogAction;
	  KAction* reportBugAction;
	  KAction* aboutAction;
	  KAction* showConnectionInfo;
	  KAction* showSettingsDialog;

	  void push               (KNetworkManager*);
	  void addVPNConnection   (VPNConnection*, bool);
	  void addDialUp          (DialUp*);
	  void addWirelessNetwork (Device*, Network*);
	  void addWiredDevice     (Device*, const QString &);
	  void mouseMoveEvent     (QMouseEvent* e);
	  void mousePressEvent    (QMouseEvent* e);

	  QPoint getAnchor (void) const;

	  void loadIcons();
	  void drawContents (QPainter *p);
	  QPixmap updateForState( NMState state );
	  QPixmap pixmapForStage();

	
	signals:
	  void userInteraction         (void);
	  void configureVPNConnections (void);
	  void activateVPNConnection   (VPNConnection*);
	  void disconnectVPNConnection (void);
	  void activateDialUp          (DialUp*);
	  void deactivateDialUp        (DialUp*);
	  void activateDevice          (Device*);
	  void activateNetwork         (Network*, Device*);
	  void destroyActivationStage  (void);

	public slots:
	  void updateTooltip          (void);
	  void connectHiddenNetwork   (void);
	  void configureVPN           (void);
	  void disconnectVPN          (void);
	  void configureDialUp        (void);
	  void configureNotifications (void);
	  void switchState            (void);
	  void switchWirelessOn       (void);
	  void switchWirelessOff      (void);
	  void itemActivated          (int);
	  void itemHighlighted        (int);
	  void vpnItemActivated       (int);
	  void dialUpItemActivated    (int);
	  void addWirelessNetworks    (Device*);
	  void addSubheading          (KPopupMenu*, QWidget*, const QString &, const QPixmap);
	  void contextMenuAboutToShow (KPopupMenu*);
	  void showNetworksDialog();
	  void slotStateChanged();
	  void slotIconTimer();

	  void slotDeviceAdded( Device * );
	  void slotDeviceRemoved( Device * );
	  void slotLinkUp( Device * );
	  void slotLinkDown( Device * );

	  void slotNMSleeping();
	  void slotNMConnecting();
	  void slotNMConnected();
	  void slotNMDisconnected();

	  void slotNetworkFound( Network * );
	  void slotNetworkDisappeared( Network * );
	  void vpnConnectionStateChanged(bool);
	  void slotShowConnectionInfo();
	  void slotShowSettingsDialog();
	  void slotQuit();

	private:
	  void enterEvent (QEvent*);

	  KNetworkManager*          _ctx;
	  QMap<int, VPNConnection*> _vpnMap;
	  QMap<int, DialUp*>        _dialUpMap;
	  QMap<int, QString>        _deviceMap;
	  QMap<int, QString>        _networkMap;
	  QString                   _tooltip;
	  KPopupMenu*               _vpnMenu;
	  KPopupMenu*               _dialUpMenu;
	  KPopupMenu*               _optionsMenu;
	  KPopupMenu*               _helpMenu;
	  
	  //icon stuff
  	  QPixmap m_pixmaps[NUM_CONNECTING_STAGES][NUM_CONNECTING_FRAMES];
	  int m_step;
	  bool m_animated;
	  QTimer m_iconTimer;
	
	  QPixmap m_disconnected;
	  QPixmap m_wired;
	  QPixmap m_dialup;
	  QPixmap m_adhocWireless;
	  QPixmap m_wireless00;
	  QPixmap m_wireless25;
	  QPixmap m_wireless50;
	  QPixmap m_wireless75;
	  QPixmap m_wireless100;
	  QPixmap m_background;
	  QPixmap m_overlay;
	  QPoint _anchor;
};

#endif /* KNETWORKMANAGER_TRAY_H */
