/***************************************************************************
                          kfvlog.h  -  description
                             -------------------
    begin                : Fri Aug 31 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : wehjin@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFVLOG_H
#define KFVLOG_H

#include <qwidget.h>
#include <qgroupbox.h>

class QMultiLineEdit;
class QPushButton;
class QLayout;
class QLineEdit;

class KFMLog;

/**View class to display a log
  *@author Jeffrey Yu
  */

class KFVLog : public QGroupBox  {
   Q_OBJECT
public: 
	KFVLog(QWidget *parent=0, const char *name=0);
	~KFVLog();
	
	void log(KFMLog* log);
	
private:
	QMultiLineEdit* mleBody_;
	QPushButton* pbApply_;
	QPushButton* pbReset_;
	QLineEdit* leDate_;
	QPushButton* pbChange_;
	
	KFMLog* log_;

	void createWidgets();
	void createDateWidgets(QLayout* l);
	void createBodyWidgets(QLayout* l);
	void createActionWidgets(QLayout* l);

private slots:	
  /** Slot to receive textChanged signal from the body mle */
  void onMleBodyTextChanged();
	/** Slot to receive clicked signal from the change(date) pushbutton */
	void onPbChangeClicked();
};

#endif
