/***************************************************************************
                          imageitem.cpp  -  description
                             -------------------
    begin                : Don Jun 5 2003
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qurl.h>
#include <klocale.h>
#include <ksimpleconfig.h>
#include "imageitem.h"
#include "kgraph.h"
#include "utils.h"
#ifndef KPL_CLASSES_ONLY
#include <qlistview.h>
#include "imagedlg.h"
#endif

ImageItem::ImageItem()
{
}

ImageItem::ImageItem(KplNamespace::AutoStruct* aut) : fx(1.0), fy(1.0)
{
  x0 = aut->x0Auto + 0.5 * aut->xlAuto;
  y0 = aut->y0Auto + 0.5 * aut->ylAuto;
}

ImageItem::ImageItem(KSimpleConfig* plo, const KURL& uPlo) : KplItem(plo)
{
  QString s = plo->readEntry("path", "");
  url = QUrl::isRelativeUrl(s) ? (uPlo.directory(false) + s) : s;
  url.cleanPath();
  fx = plo->readDoubleNumEntry("fx", 1.0);
  fy = plo->readDoubleNumEntry("fy", 1.0);
}

ImageItem::ImageItem(bool act, double x, double y, double _fx, double _fy,
                     const KURL& u) :
 KplItem(act, x, y, 1.0), fx(_fx), fy(_fy), url(u)
{
}

ImageItem::~ImageItem()
{
}

KplItem::ItemTypes ImageItem::iType() const
{
  return Image;
}

void ImageItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (active && !url.isEmpty())
    g->image(url, x0, y0, fx, fy, &bRect);
}

#ifndef KPL_CLASSES_ONLY
void ImageItem::writePlo(KSimpleConfig* plo, const KURL& uPlo, bool _abs,
                         KplDoc*) const
{
  plo->writeEntry("Type", "IMAGEITEM");
  if (!active)
    plo->writeEntry("active", active);
  plo->writeEntry("x", x0);
  plo->writeEntry("y", y0);
  plo->writeEntry("fx", fx);
  plo->writeEntry("fy", fy);
  plo->writeEntry("path", Utils::relPath(uPlo, url, _abs));
}

void ImageItem::setText(QListViewItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Image"));
  QString s;
  it->setText(2, i18n("file") + " " + url.fileName() + ", " +
              s.sprintf("x = %g cm, y = %g cm", x0, y0));
}

int ImageItem::editItem(QWidget* parent, KplDoc* m, int)
{
  ImageDlg dlg(parent, m, this);
  return dlg.exec();
}
#endif

KplItem* ImageItem::copy() const
{
  return new ImageItem(*this);
}
