/***************************************************************************
                          kplchecklistitem.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Aug 22 1999
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLCHECKLISTITEM_H
#define KPLCHECKLISTITEM_H

#include <klistview.h>

/**
  * CheckListItem class. Provides a signal for state changes.
  * @author Werner Stille
  */
class KplCheckListItem : public QObject, public KListViewItem
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent KListView.
   * @param after pointer to KplCheckListItem to insert after.
   */
  KplCheckListItem(KListView* parent, KplCheckListItem* after = 0);
  /**
   * Constructor.
   * @param parent pointer to parent QCheckListItem.
   * @param after pointer to KplCheckListItem to insert after.
   */
  KplCheckListItem(KplCheckListItem* parent, KplCheckListItem* after = 0);
  /** Destructor. */
  ~KplCheckListItem();
  /**
   * Sets item state.
   * @param b state.
   */
  void setOn(bool b);
  /**
   * Returns item state.
   * @return state.
   */
  bool isOn() const;
  /**
   * Sets open state.
   * @param b state.
   */
  virtual void setOpen(bool b);

protected:
  /**
   * Sets icon to unchecked.
   */
  void init();
  bool on;

signals:
  /**
   * Emitted when state changed.
   * @param item pointer to KplCheckListItem.
   * @param bState new state.
   */
  void stateChanged(KplCheckListItem* item, bool bState);
  /**
   * Emitted when open state changed.
   * @param item pointer to KplCheckListItem.
   * @param open new state.
   */
  void openChanged(KplCheckListItem* item, bool open);
};

#endif
