/***************************************************************************
                          kpldoublespinbox.cpp  -  description
                             -------------------
    begin                : Do Apr 14 2005
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qvalidator.h>
#include "kpldoublespinbox.h"

KplDoubleSpinBox::KplDoubleSpinBox(double val, double stp, QWidget* _parent,
                                   char format, int prc) :
 QSpinBox(qRound(val / stp) - 1000000000, qRound(val / stp) + 1000000000, 1,
          _parent), frm(format), prec(prc)
{
  setValidator(new QDoubleValidator::QDoubleValidator(minValue() * stp,
                                                      maxValue() * stp,
                                                      prec, this));
  init(val, stp);
}

KplDoubleSpinBox::KplDoubleSpinBox(double val, double stp, double minVal,
                                   double maxVal, QWidget* _parent,
                                   char format, int prc) :
 QSpinBox(qRound(minVal / stp), qRound(maxVal / stp), 1, _parent),
 frm(format), prec(prc)
{
  setValidator(new QDoubleValidator::QDoubleValidator(minVal, maxVal, prec,
                                                      this));
  init(val, stp);
}

KplDoubleSpinBox::~KplDoubleSpinBox()
{
}

void KplDoubleSpinBox::slotValueChanged(int value)
{
  emit valueChanged(value * step);
}

double KplDoubleSpinBox::value() const
{
  return text().toDouble();
}

QString KplDoubleSpinBox::mapValueToText(int value)
{
  return QString::number((value) * step, frm, prec);
}

int KplDoubleSpinBox::mapTextToValue(bool* ok)
{
  return qRound(text().toDouble(ok) / step);
}

void KplDoubleSpinBox::init(double val, double stp)
{
  step = QString::number(stp, 'g', 2).toDouble();
  QSpinBox::setValue(qRound(val / step));
  editor()->setText(QString::number(val, frm, prec));
  connect(this, SIGNAL(valueChanged(int)), SLOT(slotValueChanged(int)));
}
