/***************************************************************************
                          scalebardlg.cpp  -  description
                             -------------------
    begin                : Sam Jun 14 2003
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <klocale.h>
#include "edittextdlg.h"
#include "kpldoubleedit.h"
#include "scalebardlg.h"
#include "scalebaritem.h"

ScaleBarDlg::ScaleBarDlg(QWidget* _parent, KplDoc* model, ScaleBarItem* sd0) :
 DecoDlg(_parent, i18n("Scale Bar"), "SEC-SCALEBAR", model, sd0, 4), sd(sd0)
{
  QFrame* frame = plainPage();
  grid->addWidget(new QLabel(i18n("Orientation"), frame), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addMultiCellLayout(hbox, 0, 0, 1, 5);
  bg = new QButtonGroup();
  QRadioButton* rb;
  bg->insert(rb = new QRadioButton(i18n("Horizontal"), frame));
  hbox->addWidget(rb);
  bg->insert(rb = new QRadioButton(i18n("Vertical"), frame));
  hbox->addWidget(rb);
  bg->setButton(sd->orientation);
  hbox->addItem(new QSpacerItem(10, 10, QSizePolicy::Expanding));
  grid->addWidget(new QLabel(i18n("Text"), frame), 1, 0);
  grid->addWidget(eText = new QLineEdit(sd->s, frame), 1, 1);
  QPushButton* b = new QPushButton("...", frame);
  b->setFixedWidth(28);
  grid->addWidget(b, 1, 2);
  connect(b, SIGNAL(clicked()), SLOT(slotEditText()));
  grid->addWidget(new QLabel(i18n("Length"), frame), 1, 4);
  grid->addWidget(eLen = new KplDoubleEdit(sd->len, 0.0, 200.0, frame), 1, 5);
  grid->addWidget(new QLabel("cm", frame), 1, 6);
  initEntries(2);
}

ScaleBarDlg::~ScaleBarDlg()
{
  delete bg;
}

void ScaleBarDlg::getValues(bool ok)
{
  sd->orientation = bg->id(bg->selected());
  sd->s = eText->text();
  sd->len = eLen->value();
  DecoDlg::getValues(ok);
}

void ScaleBarDlg::slotEditText()
{
  EditTextDlg dlg(this, eText);
  dlg.exec();
}

void ScaleBarDlg::slotOk()
{
  getValues(true);
}

void ScaleBarDlg::slotApply()
{
  getValues(false);
}
