/***************************************************************************
                            kstfilteredvector.cpp
                             -------------------
    begin                : Mon Dec 15 2003
    copyright            : (C) 2003 by The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kstfilteredvector.h"

#include "kstdatacollection.h"

#include <kdebug.h>


KstFilteredVector::KstFilteredVector(KstVectorPtr parent, KstFilterSetPtr filterSet)
: KstVector(parent->tagName() + "-" + filterSet->name(), parent->length()), _parent(parent), _filterSet(filterSet) {
  update();
}


KstFilteredVector::KstFilteredVector(QDomElement& e) : KstVector() {
  QDomNode n = e.firstChild();
  while(!n.isNull()) {
    QDomElement e = n.toElement();
    if(!e.isNull()) {
      if (e.tagName() == "tag") {
        setTagName(e.text());
      } else if (e.tagName() == "parent") {
        _parent = *KST::vectorList.findTag(e.text());
        if (_parent) {
          resize(_parent->length());
        }
      } else if (e.tagName() == "filterset") {
        _filterSet = KST::filterSetList.find(e.text());
      }
    }
    n = n.nextSibling();
  }
}


KstFilteredVector::~KstFilteredVector() {
}


KstObject::UpdateType KstFilteredVector::update(int update_counter) {
  KstObject::UpdateType ut = KstObject::NO_CHANGE;
  if (_parent && _filterSet) {
    ut = _parent->update(update_counter);
    _filterSet->apply(_parent, KstVectorPtr(this));
  }

  if (update_counter == -1 || ut != KstObject::NO_CHANGE) {
    KstObject::UpdateType u = KstVector::update(update_counter);
    if (ut != KstObject::UPDATE) {
      ut = u;
    }
  }

  return ut;
}


void KstFilteredVector::save(QTextStream& ts) {
  if (!_parent || !_filterSet) {
    return;
  }

  ts << "  <tag>" << tagName() << "</tag>" << endl;
  ts << "  <parent>" << _parent->tagName() << "</parent>" << endl;
  ts << "  <filterset>" << _filterSet->name() << "</filterset>" << endl;
}


// vim: ts=2 sw=2 et
