/***************************************************************************
                   ksttoplevelview.h: class for the toplevel view
                             -------------------
    begin                : Mar 11, 2004
    copyright            : (C) 2003 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTTOPLEVELVIEW_H
#define KSTTOPLEVELVIEW_H

#include <qcursor.h>
#include <qpainter.h>
#include <qwidget.h>

#include <kprinter.h>

#include "kstplotbase.h"
#include "kstviewobject.h"

class KPopupMenu;
class KstViewWidget;

class KstTopLevelView : public KstViewObject {
  friend class KstViewWidget;
  Q_OBJECT
  public:
    KstTopLevelView(QWidget *parent = 0L, const char *name = 0L, WFlags w = 0);
    KstTopLevelView(QDomElement& e, QWidget *parent = 0L, const char *name = 0L, WFlags w = 0);
    virtual ~KstTopLevelView();

    virtual UpdateType update();
    virtual void save(QTextStream& ts);

    KstViewWidget *widget() const;

    virtual void resize(const QSize& size);
    virtual void paint(KstPaintType type, QPainter& p);

    void updateAlignment();
    void paint(KstPaintType type, bool erase = false);

    void clearFocus();
    enum ViewMode { LayoutMode = 0, DisplayMode, Unknown = 15 };
    ViewMode viewMode() const { return _mode; }
    void setViewMode(ViewMode v);

    // Are we tracking (rubber band / move / resize)
    bool tracking() const;
    bool trackingIsMove() const;

    KstViewObjectList& selectionList() { return _selectionList; }
    KstViewObjectPtr pressTarget() const { return _pressTarget; }

    template<class T> KstSharedPtr<T> createPlot(const QString& name);

    virtual void cleanup(int cols = -1);

    bool mouseGrabbed() const { return _mouseGrabbed; }
    KstViewObjectPtr mouseGrabber() const { return _mouseGrabber; }
    bool grabMouse(KstViewObjectPtr me);
    void releaseMouse(KstViewObjectPtr me);

  private slots:
    void menuClosed();
    void makeSameWidth();
    void makeSameHeight();
    void makeSameSize();
    void alignLeft();
    void alignRight();
    void alignTop();
    void alignBottom();
    void groupSelection();
    void cleanupAction();

  protected:
    void resized(const QSize& size);
    void cancelMouseOperations();
    void updateFocus(const QPoint& pos);
    bool handlePress(const QPoint& pos, bool shift = false);
    void pressMove(const QPoint& pos);
    void releasePress(const QPoint& pos, bool shift = false);
    void setCursorFor(const QPoint& pos, const QRect& objGeom);
    bool popupMenu(KPopupMenu *menu, const QPoint& pos);
    void checkPosition( KstViewObjectPtr pObject, QPoint point );

    // Called as a response to drag re-entering widget()
    void restartMove();

  private:
    void commonConstructor();

    KstViewWidget *_w;
    bool _focusOn : 1;
    bool _mouseGrabbed : 1;
    ViewMode _mode : 4;
    signed int _pressDirection : 5;
    QCursor _cursor;
    QPoint _moveOffset;
    KstViewObjectPtr _pressTarget, _hoverFocus;
    QRect _prevBand;
    KstViewObjectList _selectionList;
    KstViewObjectPtr _mouseGrabber;
};

typedef KstSharedPtr<KstTopLevelView> KstTopLevelViewPtr;
typedef KstObjectList<KstTopLevelViewPtr> KstTopLevelViewList;

template<class T>
KstSharedPtr<T> KstTopLevelView::createPlot(const QString& name) {
  T *plot = new T(name);
  if (_onGrid) {
    // FIXME: make this more powerful, preserve columns
    appendChild(plot);
    cleanup();
  } else {
    // FIXME: run the positioning algorithm
    plot->resize(QSize(250, 100));
    plot->move(QPoint(30, 30));
    appendChild(plot);
  }
  //paint(P_PAINT);
  return plot;
}


#endif
// vim: ts=2 sw=2 et
