/***************************************************************************
                          engine.h  -  description
                             -------------------
    begin                : Thu Feb 15 2001
    copyright            : (C) 2001 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ENGINE_H
#define ENGINE_H

#include <qstring.h>
class KConfig;
class QTextView;
class QWidget;
class QPoint;

/**
 * This class is the applications workhorse. It does the translation / calls
 * steak. The translation depends on the flags.
 *
 * @short Does the work/translation
 * @author Olaf Hartig
 */
class Engine
{
 public:
  /** Constructs a new engine with all flags false. */
  Engine();
  /** Constructs a new engine by restoring it's status (see @ref Engine::restoreStatus). */
  Engine( KConfig * pConfig );

  /** Saves the engines status (flags) to the current group in the given config-file. */
  void saveStatus( KConfig * pConfig );
  /** Restores the engines status (flags) from the current group in the given config-file. */
  void restoreStatus( KConfig * pConfig );

  /**
   * Translates the given word. Appends the formatted translation to the given view.
   * Translates the clipboard-entry, if an empty word is given.
   * @param nRows number of appended rows
   * @param szMaxLine longest appended line
   */

  void translate( const QString & szWord, QTextView * pView);//, int & nRows, QString & szMaxLine);
  /** Creates a popup-window and uses @ref Engine::translate to fill it's view. */
  void translatePopup( const QString & szWord, QTextView * pView );

  bool _fEnglish;
  bool _fGerman;
  bool _fContext;
  bool _fSensitive;
  bool _fSearchAnd;
  bool _fSearchOr;

  int nRows;
  QString szMaxLine;
};

#endif
