/***************************************************************************
                          gphoto_interface.h  -  description
                             -------------------
    begin                : Sun Dec 30 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GPHOTO_INTERFACE_H
#define GPHOTO_INTERFACE_H


/**
  *@author Renchi Raju
  */

#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qobject.h>
#include <qpixmap.h>

extern "C" {
	#include <stdio.h>
	#include <gphoto2-camera.h>
	#include <gphoto2-abilities-list.h>
	#include <gphoto2-file.h>	
	#include <gphoto2-list.h>
	#include <gphoto2-port-info-list.h>
	#include <gphoto2-setting.h>
	#include <gphoto2-port-log.h>
}

class Gphoto_Interface {

 public: 

  Gphoto_Interface(bool setup);
  ~Gphoto_Interface();

  int initCamera();
  bool isCameraInitialised();
  void setCameraInitialised(bool init);

  int getSubFolders(QString folder, QStringList& subFolderList, QStringList& subFolderNameList,
		    int& numSubFolders);
  int getImageNames(QString folder, QStringList& imagesList,  QStringList& imagesInfoList);
  QPixmap* getThumbNail(QString folder, QString imageName);
  int downloadImage(QString folder, QString imageName, QString saveFile);
  int deleteImage(QString folder, QString imageName);
  int makeDir(QString folder, QString newFolder);

  bool cameraSupportsThumbNails();
  bool cameraSupportsDelete();
  bool cameraSupportsUpload();
  bool cameraSupportsMkDir();
  bool cameraSupportsDelDir();
  
  // setup functions
  void getSupportedCameras(QStringList& cameraList, int& numSupported);
  void getSupportedPorts(QStringList& portList);
  void getCameraSettings(QString& cameraModel, QString& cameraPort);
  void saveCameraSettings(QString cameraModel, QString cameraPort);
  void getCameraPorts(QString cameraModel, QStringList& supportedPorts);
  int  autoDetectCamera(QString& cameraModel, QString& cameraPort);

  // camera information functions
  void getCameraSummary(QString& cameraSummary);
  void getCameraManual(QString& cameraManual);
  void getCameraAbout(QString& cameraAbout);

 private:

    Camera *my_camera;
    CameraAbilities my_cameraAbilities;
    QString my_cameraModel;
    QString my_cameraPort;
    QString my_cameraPortPath;

    bool my_cameraInitialised;

    bool my_cameraSupportsThumbNails;
    bool my_cameraSupportsDelete;
    bool my_cameraSupportsUpload;
    bool my_cameraSupportsMkDir;
    bool my_cameraSupportsDelDir;

    int setupCamera();
    void setupCameraAbilities();

    static void status_func (Camera *camera, const char *status, void *data);
    static void message_func (Camera *camera, const char *message, void *data);
    static void progress_func (Camera *camera, float percentage, void *data);

    static void debug_func (GPLogLevel level, const char *domain, const char *format,
			    va_list args, void *data); 

};



#endif
